#!/usr/local/bin/php

<?php
/**********************************************************/
// This PHP script acquires syslog warning message and sends mail.
// Add in syslog.conf as: local1.=warning <TAB> | /path/sendreportmail.php
// The following warning message is reported when a MAC address registered in
//   watchlist table is detected by opengatemd.
// "Sep 29 12:34:56 opengate01 opengatemd[1234]: WARN: find mac=11:22:33:44:55:66 ip=192.168.0.10"
/**********************************************************/

/*** parameters ***/
$mysqlServer="localhost";
$mysqlUser="root";
$mysqlPassword="";
$mailSender="opengate@cc.saga-u.ac.jp";
$reportInterval="6 HOUR";

// open syslog
openlog('sendreportmail', LOG_PID, LOG_LOCAL1);

// get mac address and others from syslog message
list($timestamp, $gatewayName, $macAddress, $ipAddress)=getDataFromSyslog();
if($timestamp=="?") return;

// prepare database 
if(!($link=prepareMysql($mysqlServer, $mysqlUser, $mysqlPassword))) return;
if(!$link)return;

// get mail address and others from mysql db
if(!(list($device, $mailAddress)=getDataFromMysql($macAddress))){
	mysqli_close($link);
	return;
}

// if recent report exists, skip to send report
if(skipReporting($link, $macAddress, $gatewayName, $reportInterval)){
	mysqli_close($link);
	return;
}

// close database
mysqli_close($link);

// send mail to the user
sendMailToUser($mailSender, $mailAddress, $device, $gatewayName, 
		$ipAddress, $timestamp);
return;


/***
get MAC address and others from syslog 
***/
function getDataFromSyslog(){
	$timestamp="?";
	$gatewayName="?";
	$macAddress="?";
	$ipAddress="?";

	// syslog message is acqiured from STDIN
	if(($message=fgets(STDIN))==FALSE){
		syslog(LOG_INFO, 'ERR: Fail to read from stdin');
		return FALSE;
	}

	// extract timestamp, gateway and macaddress by regular expression
	if(preg_match('/^(.*) (.*) .* WARN: find mac=(.*) ip=(.*)/',
	 $message, $matches)==1){
		$timestamp = $matches[1];
		$gatewayName = $matches[2];
		$macAddress = $matches[3];
		$ipAddress = $matches[4];
	}else{
		syslog(LOG_INFO, 'ERR: Fail to analyze syslog message');
	}
	return array($timestamp, $gatewayName, $macAddress, $ipAddress);
}

/***
prepare mysql connection
***/
function prepareMysql($mysqlServer, $mysqlUser, $mysqlPassword){

	// connect and access to MySql DB
	$link = mysqli_connect($mysqlServer, $mysqlUser, $mysqlPassword);
	if (!$link){
		syslog(LOG_INFO, 'ERR: Cannot connect DB '.mysqli_error());
		return FALSE;
	}

	// use opengatem database
	$db_selected = mysqli_select_db($link, 'opengatem');
	if (!$db_selected){
		syslog(LOG_INFO, 'ERR: Cannot select DB '.mysqli_error());
		return FALSE;
	}
	mysqli_set_charset($link, 'utf8');
	return $link;
}

/***
get mail address and others corresponding to the MAC address from mysql 
***/
function getDataFromMysql($macAddress){
	$device="?";
	$mailAddress="?";

	// query
	$result = mysqli_query($link, 'SELECT device, mailAddress FROM macaddrs 
		WHERE macAddress="'.$macAddress.'" AND status!="D"');
	if (!$result){
		syslog(LOG_INFO, 'ERR: Fail DB query '.mysqli_error());
		return FALSE;
	}

	// get result
	if($row = mysqli_fetch_row($result)){
		$device = $row[0];
		$mailAddress = $row[1];
	}else{
		syslog(LOG_INFO, 'ERR: Fail to get mail address from DB');
		return FALSE;
	}

	return array($device, $mailAddress);
}

/***
to avoid to send too many mails, 
skip if there are recent logs having same macaddress, and same gateway 
PLEASE MODIFY to control the report frequency.
***/
function skipReporting($link, $macAddress, $gatewayName, $reportInterval){
	
	// query
	$result = mysqli_query($link, 'SELECT count(*) FROM sessionmd '
		.'WHERE EXISTS (SELECT * FROM sessionmd '
		.'WHERE macAddress="'.$macAddress.'" '
		.'AND gatewayName LIKE "'.$gatewayName.'.%" '
		.'AND openTime > NOW() - INTERVAL '.$reportInterval.' '
		.'AND openTime < NOW() - INTERVAL 1 MINUTE '
		.')'
		);

	if (!$result){
		syslog(LOG_INFO, 'ERR: Fail query '.mysqli_error());
		return TRUE;
	}

	// get data
	if($row = mysqli_fetch_row($result)) $count = $row[0];
	else	$count = 0;

	// if recent logs exist, skip is true
	if($count>0)return TRUE;
	else return FALSE;
}

/***
send mail to the mail address
***/
function sendMailToUser($mailSender, $mailAddress, $device, $gatewayName, 
		$ipAddress, $timestamp){
	
	$to=$mailAddress;
	$subject="Your device is detected";
	$message="Your device ".$device
	." is detected as ip=".$ipAddress
	." on the subnet under ".$gatewayName
	." at ".$timestamp
	.". "
	." If it is not your use, please contact to the administrator.";
	$headers="From: ".$mailSender."\n";
	$parameters="-f ".$mailSender;

	if(mb_send_mail($to, $subject, $message, $headers, $parameters)){
		syslog(LOG_INFO, 'INFO: Success to send mail');
		return TRUE;
	}else{
		syslog(LOG_INFO, 'ERR: Fail to send mail');
		return FALSE;
	}
}
?>
