/**************************************************
OpengateM - MAC address authentication system 
 module for Communication through CGI 

Copyright (C) 2011 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp

Programmed by Yoshiaki WATANABE
**************************************************/

#include	"opengatemmng.h"

int messageSet[ENDOFLIST]={0};

/*******************************
 set message
*******************************/
void setMessage(int msgNo){

  if(msgNo < ENDOFLIST) messageSet[msgNo]=TRUE;
}

/*******************************
 reset message
*******************************/
void resetMessage(void){
  int i;
  for(i=0;i<ENDOFLIST;i++) messageSet[i]=FALSE;
}

/*******************************
 insert message in multi-lang to page
*******************************/
void insertMessageToPage(char* language){
  
  char* (*pMessageFunc)(int msgNo);
  int i;

  /* get message in language indicated in argument */
  if(strcmp(language, "ja")==0)      pMessageFunc=messagesInJa;
  else if(strcmp(language, "en")==0) pMessageFunc=messagesInEn;

  /* if not indicated in argument, use conf value */
  else if(strcmp(GetConfValue("HtmlLangs"),"ja")==0) pMessageFunc=messagesInJa;
  else if(strcmp(GetConfValue("HtmlLangs"),"en")==0) pMessageFunc=messagesInEn;

  /* if no conf value, use english message */
  else                               pMessageFunc=messagesInEn;

  /* print messages that flag on */
  for(i=0; i<ENDOFLIST; i++){
    if(messageSet[i]) printf("%s<br>\n",(*pMessageFunc)(i));
  }
}

/******************************
 error message in english
******************************/
char* messagesInEn(int msgNo){
  char* messages[ENDOFLIST];
  messages[ExistentMacAddr]="Error: Mac address is already registered. Update it in update page.";
  messages[DeviceCountOver]="Error: Device count reachs to the limit per one user. To register new device, remove a registered device.";
  messages[IllegalMacAddrForm]= "Error: Mac address format is illegal.";
  messages[IllegalCharInDevice]="Error: Not permitted character is found in device name.";
  messages[IllegalCharInMailAddr]="Error: Not permitted character is found in mail address.";
  messages[EmptyDeviceName]="Error: Registration device name is empty.";
  messages[SuspectNat]="Error: Mac Address cannot detect. Accessed via NAT or router.";
  messages[NoInfoInDb]="Error: Cannot get user information.";
  messages[IllegalUserId]="Error: Illegal userId.";
  messages[IllegalMacAddr]="Error: Illegal MAC address.";
  messages[NoService]="Error: Cannot serve now.";
  messages[NoDaemon]="Error: Resident program mulfunctions. Contact to the administrator.";
  messages[ModifyCountOver]="Error: Modification count overflows. Retry after one day.";  
  messages[RegisterSuccess]="Registration is performed. Network is enabled.";
  messages[UpdateSuccess]="Update is performed.";
  messages[IllegalCookie]="Error: Cannot get correct cookie.";
  messages[NotSetAdminCookie]="Error: Cannot found admin cookie. Enter from check page.";
  messages[RequestAdminAuth]="Enter Administrator's userID and password.";
  messages[UnallowableAgent]="Cannot recognize the terminal to be allowable.";

  return messages[msgNo];
}

/******************************
 error message in japanese (utf-8)
******************************/
char* messagesInJa(int msgNo){
  char* messages[ENDOFLIST];
  messages[ExistentMacAddr]= "エラー：既登録のMACアドレスです。更新ページで更新してください。";
  messages[DeviceCountOver]= "エラー：一人当りの許容機器数に達しています。新たな機器を登録するには登録済の一つを削除してください。";
  messages[IllegalMacAddrForm]=  "エラー：MACアドレスの形式が不正です。";
  messages[IllegalCharInDevice]="エラー：許容されていない文字が機器名にあります。";
  messages[IllegalCharInMailAddr]="エラー：許容されていない文字がメールアドレスにあります。";
  messages[EmptyDeviceName]= "エラー：機器名が入力されていません。";
  messages[SuspectNat]=  "エラー：NAT/Router経由なのでMACアドレスが取れません。";
  messages[NoInfoInDb]="エラー：ユーザ情報を得られません。";
  messages[IllegalUserId]="エラー：不正なユーザIDです。";
  messages[IllegalMacAddr]="エラー：不正なMACアドレスです。";
  messages[NoService]="エラー：サービスを提供できません。";
  messages[NoDaemon]="エラー: 常駐プログラムが不調です。管理者に連絡下さい。";
  messages[ModifyCountOver]="エラー: 変更回数が制限を越えました。1日経ってから実行下さい。";
  messages[RegisterSuccess]="登録を完了しました。ネットワークを利用できます。";
  messages[UpdateSuccess]="更新を完了しました。";
  messages[IllegalCookie]="エラー： 正しいCookieを取得できません。";
  messages[NotSetAdminCookie]="エラー ： 管理者のCookieを取得できません。チェックページから入って下さい。";
  messages[RequestAdminAuth]="管理者のIDとPasswordを入力してください。";
  messages[UnallowableAgent]="登録許容端末と認識できません。";
  return messages[msgNo];
}

/***********************************
make weekday string for language
***********************************/
char* weekdayStr(int weekday, char* str, char* language){

  char* weekdayStrEn[7]={"Mon","Tue","Wed","Thu","Fri","Sat","Sun"};
  char* weekdayStrJa[7]={"月","火","水","木","金","土","日"};

  if(strcmp(language, "ja")==0)      str=weekdayStrJa[weekday];
  else if(strcmp(language, "en")==0) str=weekdayStrEn[weekday];
  else if(strcmp(GetConfValue("HtmlLangs"),"ja")==0) str=weekdayStrJa[weekday];
  else if(strcmp(GetConfValue("HtmlLangs"),"en")==0) str=weekdayStrEn[weekday];
  else                               str=weekdayStrEn[weekday];
  return str;
}

/**********************************
 *********************************/
void SetMessage(int msgNo){
  if(debug>1) err_msg("DEBUG:=>setMessage(%d)", msgNo);
  setMessage(msgNo);
  if(debug>1) err_msg("DEBUG:<=setMessage( )");
}

void ResetMessage(void){
  if(debug>1) err_msg("DEBUG:=>resetMessage()");
  resetMessage();
  if(debug>1) err_msg("DEBUG:<=resetMessage( )");
}

void InsertMessageToPage(char* language){
  if(debug>1) err_msg("DEBUG:=>insertMessageToPage(%s)",language);
  insertMessageToPage(language);
  if(debug>1) err_msg("DEBUG:<=insertMessageToPage( )");
}

char* WeekdayStr(int weekday, char* str, char* language){
  char* ret;
  if(debug>1) err_msg("DEBUG:=>weekdayStr(%d,,%s)",weekday,language);
  ret=weekdayStr(weekday,str,language);
  if(debug>1) err_msg("DEBUG:<=weekdayStr(%s)",str);
  return ret;
}


