/************************************
make vendor table in MySql database
 left-half of mac address indicates the NIC vendor
 the assignment list is obained from the following url
  http://standards.ieee.org/develop/regauth/oui/oui.txt
  (this list is updated daily)
   download oui.txt and execute as 
    makevendortable > mysqlinsertscript
   the output file is used for mysql script as
    mysql < mysqlinsertscript
************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define BUFFMAXLN 1000

void rmQuoteChar(char* buff);

int main(void){

  FILE* file;
  char buff[BUFFMAXLN];
  char* ret;
  char* ptab;
  char oui[BUFFMAXLN];
  char org[BUFFMAXLN];
  char addr[BUFFMAXLN];
  int i;

  /* file open */
  if((file = fopen("oui.txt", "r"))==NULL){
    printf("\nInput file is not found\nRefer comment in source file\n\n");
    return 0;
  }

  /* skip header */
  ret=fgets(buff, BUFFMAXLN, file);
  while(ret!=NULL){
    if(strstr(buff,"00-00-00")==buff)break;
    ret=fgets(buff, BUFFMAXLN, file);
  }

  /* loop until eof */
  while(ret!=NULL){
    
    /* get OUI and Orginization */
    ptab=strrchr(buff, '\t');
    buff[8]='\0';
    *ptab='\0';
    strcpy(oui, buff);
    strcpy(org, ptab+1);
    *strchr(org, '\n')='\0';

    /* skip company_id line */
    ret=fgets(buff, BUFFMAXLN, file);

    /* get Address 1st line */
    ret=fgets(buff, BUFFMAXLN, file);
    ptab=strrchr(buff, '\t');
    strcpy(addr, ptab+1);

    /* get more lines */
    ret=fgets(buff, BUFFMAXLN, file);
    while((ptab=strrchr(buff, '\t'))!=NULL){
      strcat(addr, ptab+1);
      ret=fgets(buff, BUFFMAXLN, file);
    }

    /* skip null lines */
    while((ptab=strrchr(buff, '\t'))==NULL){
      ret=fgets(buff, BUFFMAXLN, file);
      if(ret==NULL) break;
    }

    /* convert upcase char to lowcase and separator '-' to ':' */
    for(i=0; i<strlen(oui); i++){
      oui[i]=tolower(oui[i]);
      if(oui[i]=='-') oui[i]=':';
    }

    /* put MySql insert format */
    rmQuoteChar(org);
    printf("insert into opengatem.nicvendors values('%s','%s');\n",
	   oui,org);
  }

  return 0;
}

/** remove quotation character **/
void rmQuoteChar(char* buff){

  /* Do until End of String */
  while(*buff!='\0'){
    if(*buff=='\'' || *buff=='\"') *buff=' ';
    buff++;
  }
}
