/**************************************************
opengate mac addr auth program

 module for cgi main

Copyright (C) 2011 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include	"opengatemmng.h"

/***************************************************/
/*  main routine called as cgi from Web server     */
/***************************************************/
int  main(int argc, char **argv)
{
  char language[WORDMAXLN]="";
  char userId[USERMAXLN]="";
  char extraId[USERMAXLN]="";
  char requestStr[BUFFMAXLN]=""; /* http request string */
  char* progName="";
  char mailDefault[BUFFMAXLN]="";

  /* drop root privilege */
  seteuid(getuid());

  /* save program load path */
  saveLoadPath(argv[0]);
  progName = getProgramName();

  /* prepare config file */
  if(OpenConfFile()==-1){
    PutMessageToClient("Check config file by running this cgi on console");
    return 0;
  }
 
  /* start log */
  errToSyslog(atoi(GetConfValue("Syslog/Enable")));
  openlog(progName, LOG_PID, atoi(GetConfValue("Syslog/Facility")));

  /* initialize config */
  InitConf();
  if(!InitMngDb()) return 0;
  if(!InitWorkDb()) return 0;

  /* get language from query string */
  GetLangFromQueryString(language);

  /* get post data */
  GetPostData(requestStr, BUFFMAXLN);

  /* get userid. if not get, exit */
  if(!GetUserId(requestStr, userId, extraId, language, NORMALUSER,
		GetConfValue("UpdateCgi"),mailDefault)){
    CloseMngDb();
    return 0;
  }

  /* if many modify request per day, ignore the request */
  if(CountMacModifyPerDayInMngDb(userId,extraId) 
     > atoi(GetConfValue("MaxMacModifyPerDay"))){
    SetMessage(ModifyCountOver);
    PutDenyToClient(language);
    CloseMngDb();
    return 0;
  }

  /* analyze request from client */
  if(!isNull(requestStr)){
    
    /* analize string and execute requests */
    if(AnalyzeUpdateRequestAndExecute(requestStr, userId, extraId)){
      SetMessage(UpdateSuccess);
    }
  }

  /* prepare response and send to client */
  PutUpdatePageToClient(language, userId, extraId);

  /* finalize */
  CloseMngDb();
  return 0;
}
