/**************************************************
opengate mac addr auth program

 module for mac address registration cgi main

Copyright (C) 2011 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include	"opengatemmng.h"

/***************************************************/
/*  main routine called as cgi from Web server     */
/***************************************************/
int  main(int argc, char **argv)
{
  char language[WORDMAXLN]="";
  char requestStr[BUFFMAXLN]=""; /* http request string */
  char macAddress[ADDRMAXLN]="";
  char mailAddress[BUFFMAXLN]="";
  char mailDefault[BUFFMAXLN]="";
  char deviceName[BUFFMAXLN]="";
  char userId[USERMAXLN]="";
  char extraId[USERMAXLN]="";
  char* progName="";
  char adminCookie[SIDMAXLN]="";

  /* drop root privilege */
  seteuid(getuid());

  /* save program load path */
  saveLoadPath(argv[0]);
  progName = getProgramName();

  /* prepare config file */
  if(OpenConfFile()==-1){
    PutMessageToClient("Check config file by running this cgi on console");
    return 0;
  }
 
  /* start log */
  errToSyslog(atoi(GetConfValue("Syslog/Enable")));
  openlog(progName, LOG_PID, atoi(GetConfValue("Syslog/Facility")));

  /* initialize config */
  InitConf();
  if(!InitMngDb()) return 0;

  if(IsShibOrBasicAuthDuplicated()){
    PutMessageToClient("Error: Duplicated Shibboleth or HttpBasic setting");
    return 0;
  }

  /* get items in query string (sent from opengatemchk) */
  GetLangFromQueryString(language);
  GetMacAddrFromQueryString(macAddress);

  /* if accessed via nat, return  */
  if(IsNatSuspectedInWorkDb(macAddress)){
    SetMessage(SuspectNat);
    PutDenyToClient(language);
    CloseMngDb();
    return 0;
  }

  /* if not get admin cookie, return */
  if(!IsCorrectCookie(adminCookie, ADMINUSER)){
    SetMessage(NotSetAdminCookie);
    PutDenyToClient(language);
    return 0;
  }
  if(!isNull(macAddress)) SaveMacForCookieToWorkDb(adminCookie,macAddress);

  /* get post data */
  GetPostData(requestStr, BUFFMAXLN);

  /* get userid. if not get, exit */
  if(!GetUserId(requestStr, userId, extraId, language, NORMALUSER,
		GetConfValue("RegisterCgi"), mailDefault)){
    CloseMngDb();
    return 0;
  }

  /* if overflow max device count, return  */
  if(CountMacAddrsForUserInMngDb(userId,extraId) 
     >= atoi(GetConfValue("MaxDevices"))){
    SetMessage(DeviceCountOver);
    PutDenyToClient(language);
    CloseMngDb();
    return 0;
  }
  
  /* if post data, analyze it*/
  /* analyze request from client */
  if(!isNull(requestStr)){
    if(AnalyzeRegisterRequest(requestStr, macAddress, deviceName, mailAddress)){
      /* register to db */
      RegistMacAddrToMngDb(macAddress,deviceName,userId,extraId,mailAddress);
      PutMacModifyLogToMngDb(userId, extraId, macAddress, 'R');
      SetMessage(RegisterSuccess);

      /* refresh daemon cache */
      if(GetConfValue("EnableSendingHup")) CheckDaemonAndSendHupSignal();
    }
  }    

  /* prepare response and send to client */
  /* restore mac address sent from oepngatemchk */
  if(isNull(mailAddress)) strcpy(mailAddress, mailDefault);
  if(isNull(macAddress)) LoadMacForCookieFromWorkDb(adminCookie,macAddress);
  PutRegisterPageToClient(language, macAddress, deviceName, mailAddress, userId, extraId);

  /* finalize */
  CloseMngDb();

  return 0;
}

/********************************
 check running of opengatemd daemon
 and send hup signal to the daemon
 *******************************/
void checkDaemonAndSendHupSignal(void){
  FILE* file;
  struct stat st;
  char* lockFileMd;
  int pid;

  /* get lock file name */  
  lockFileMd=GetConfValue("DaemonLockFile");

  /* if lock file is not exists, set error */
  if(stat(lockFileMd, &st)!=0){
    SetMessage(NoDaemon);
    return;
  }

  /* read pid from the file */
  if((file=fopen(lockFileMd, "r"))==NULL){
    err_msg("ERR at %s#%d: cannot open daemon lock file:%s",__FILE__,__LINE__,
	    lockFileMd);
    return;
  }

  if(fscanf(file, "%d", &pid)==0){
    err_msg("ERR at %s#%d: cannot read daemon lock file:%s",__FILE__,__LINE__,
	    lockFileMd);
    return;
  }
  fclose(file);

  /* check the daemon process running */
  if(kill(pid, 0)!=0 && errno==ESRCH) SetMessage(NoDaemon);

  /* send kill signal to the pid process if send is enabled */
  if(atoi(GetConfValue("EnableSendingHup"))){
    seteuid(0);
    kill(pid, SIGHUP);
    seteuid(getuid());
  }   
}


/*************************************
 ************************************/
void CheckDaemonAndSendHupSignal(void){
  if(debug>1) err_msg("DEBUG:=>checkDaemonAndSendHupSignal( )");
  checkDaemonAndSendHupSignal();
  if(debug>1) err_msg("DEBUG:<=checkDaemonAndSendHupSignal( )");
}
