/**************************************************
opengate mac addr auth program

 module for sending mail to warn limit date 

Copyright (C) 2011 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include	"opengatemmng.h"

/***************************************************/
/*  main routine called as cgi from Web server     */
/***************************************************/
int  main(int argc, char **argv)
{
  char mailAddress[BUFFMAXLN]; /* mail address */
  char limitDate[WORDMAXLN]; /* limit date */
  char device[WORDMAXLN]; /* device name */
  int count=0;
  char* progName;

  /* drop root privilege */
  seteuid(getuid());

  /* save program load path */
  saveLoadPath(argv[0]);
  progName = getProgramName();

  /* prepare config file */
  if(OpenConfFile()==-1){
    PutMessageToClient("Check config file by running this cgi on console");
    return 0;
  }
 
  /* start log */
  errToSyslog(atoi(GetConfValue("Syslog/Enable")));
  openlog(progName, LOG_PID, atoi(GetConfValue("Syslog/Facility")));

  /* initialize config */
  InitConf();
  if(!InitMngDb()) return 0;

  /* get mail address for users nearby limit date and send mail */
  while(GetNextMailAddressFromMngDb(mailAddress, limitDate, device)){
    if(SendMail(mailAddress, limitDate, device)) count++;
  }

  /* finalize */
  CloseMngDb();

  /* report to syslog */
  if(debug>0)  err_msg("INFO: Sended %d mails",count); 

  return 0;
}

/**************************************************/
/* send mail                                      */
/**************************************************/
int sendMail(char* mailAddress, char* limitDate, char* device)
{
  FILE* mailer;
  FILE* fp;
  char mailCmd[BUFFMAXLN];
  char buff[BUFFMAXLN];
  char* mailCmdPath;
  struct stat st;

  /* set mail command path (/bin/rmail) */
  mailCmdPath=GetConfValue("Mail/CmdPath");
  if(isNull(mailCmdPath)){
    err_msg("ERR at %s#%d: cannot get Mail/CmdPath from conf",__FILE__,__LINE__);
    return FALSE;
  }

  /* if mail command is not exists, return */
  if(stat(mailCmdPath, &st)!=0){
    err_msg("ERR at %s#%d: mail command[%s] is not found",__FILE__,__LINE__,mailCmdPath);
    return FALSE;
  }

  /* prepare mail command [/bin/rmail user@domain] */
  strncpy(mailCmd, mailCmdPath, BUFFMAXLN);
  strncat(mailCmd, " ", BUFFMAXLN);
  strncat(mailCmd, mailAddress, BUFFMAXLN);

  /* prepare a pipe connected to the mail command */
  mailer = popen(mailCmd, "w");
  if(mailer==NULL){
    err_msg("ERR at %s#%d: cannot open pipe",__FILE__,__LINE__);
    return FALSE;
  }

  /* write the mail content to the pipe */
  if((fp=fopen(GetConfValue("Mail/Content"), "r"))==NULL){
    err_msg("ERR at %s#%d: cannot find file %s",__FILE__,__LINE__, 
	    GetConfValue("Mail/Content"));
    return FALSE;
  }

  while(fgets(buff,BUFFMAXLN,fp)!=NULL){
    HtmlReplace(buff, "%%MAILADDRESS%%", mailAddress);
    HtmlReplace(buff, "%%LIMITDATE%%", limitDate);
    HtmlReplace(buff, "%%DEVICENAME%%", device);
    fputs(buff, mailer);    
  }
  fclose(fp);
  pclose(mailer);
  return TRUE;
}

/***********************************************
 routines for debugging output
***********************************************/
int SendMail(char* mailAddress, char* limitDate, char* device){
    int ret;
  if(debug>1) err_msg("DEBUG:=>sendMail(%s,%s,%s)", 
		      mailAddress, limitDate, device);
  ret=sendMail(mailAddress, limitDate, device);
  if(debug>1) err_msg("DEBUG:(%d)<=sendMail( )",ret);
  return ret;
}
