/**************************************************
opengate mac addr auth program

 module for mac address checking cgi main

Copyright (C) 2011 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include	"opengatemmng.h"

/***************************************************/
/*  main routine called as cgi from Web server     */
/***************************************************/
int  main(int argc, char **argv)
{
  char language[WORDMAXLN]="";
  char requestStr[BUFFMAXLN]=""; /* http request string */
  int status=NONE;
  char macAddress[ADDRMAXLN]="";
  char userId[USERMAXLN]="";
  char extraId[USERMAXLN]="";
  char* progName="";
  char mailDefault[BUFFMAXLN]="";

  /* drop root privilege */
  seteuid(getuid());
  
  /* save program load path */
  saveLoadPath(argv[0]);
  progName = getProgramName();

  /* prepare config file */
  if(OpenConfFile()==-1){
    PutMessageToClient("Check config file by running this cgi on console");
    return 0;
  }
 
  /* start log */
  errToSyslog(atoi(GetConfValue("Syslog/Enable")));
  openlog(progName, LOG_PID, atoi(GetConfValue("Syslog/Facility")));

  /* initialize config */
  InitConf();
  if(!InitWorkDb()) return 0;
  if(!InitMngDb()) return 0;

  /* get request language indicated in query string */
  GetLangFromQueryString(language);

  /* get post data */
  GetPostData(requestStr, BUFFMAXLN);
  
  /* get userid. if not get, exit */
  if(!GetUserId(requestStr, userId, extraId, language, ADMINUSER, 
		GetConfValue("CheckCgi"), mailDefault)){
    CloseMngDb();
    return 0;
  }

  /* analyze request from client */
  if(!isNull(requestStr)){
    AnalyzeCheckRequest(requestStr, &status, macAddress);
  }

  /* send response to client and control watch process */
  if(status==OPEN){
    PutMessageToClient("open");
    StartChildProc(macAddress);
  }    
  else if(status==CLOSE){
    PutMessageToClient("close");
    StopChildProc(macAddress);
  }
  else{
    /* make work table for checking client mac address */
    CreateMacCheckTableInWorkDb();
  
    /* put page to client */
    PutCheckPageToClient(language,userId,extraId);
  }

  return 0;
}
