/**************************************************
opengate daemon header file

Copyright (C) 2011 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/uio.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/un.h>
#include <sys/select.h>
#include <poll.h>
#include <strings.h>
#include <sys/ioctl.h>
#include <sys/filio.h>
#include <sys/sockio.h>
#include <pthread.h>
#include <sys/socket.h>
#include <syslog.h>
#include <ctype.h>
#include <stdarg.h>
#include <sys/signal.h>
#include <regex.h>
#include <sys/socket.h>
#include <net/if.h>
#include <net/ethernet.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/ip6.h>
#include <limits.h>
#include <db.h>
#include <net/if_dl.h>
#include <ifaddrs.h>
#include <sys/utsname.h>

typedef	void	Sigfunc(int);	/* for signal handlers */


/***************** constants ***********************/

/* Configuration file for opengate */ 
#define CONFIGFILE "/etc/opengate/opengatemd.conf"

#define ADDRMAXLN 128      /* maximum address string length */
#define USERMAXLN 128      /* maximum userid string length */
#define BUFFMAXLN 1024      /* maximum buffer string length */
#define WORDMAXLN 64       /* maximum word length */
#define FILTERMAXLN 128   /* pcap filter max length */

#define TRUE 1
#define FALSE 0
#define DENY   0
#define ACCEPT 1

extern int debug;

/**********prototypes***************************************/

/* opengatemd.c */
void ShowHelp(char* procName);
int LockDaemonLockFile(void);
void Daemonize(void);
void KillDaemon(void);
void ReloadDaemon(void);

/* ipfw.c */
int OpenClientGate(char *clientAddr,int forced, char* userId, char* extraId, char* macAddress);
int GetRuleNumber(char *clientAddr, int forced);
void CloseClientGate(int ruleMumber);
int GetPacketCount(int ruleNumber);
int CountRuleNumber(int ruleNumber);
int GetRuleTableFromIpfw(DB* ruleTable);

/* util.c */
int Lock(int fd);
int Unlock(int fd);
FILE *Popenl(int rootPriv, const char *type, const char *path, ...);
int Systeml(int roorPriv, const char *path, ...);
int Pclose(FILE *stream);
int isNull(const char *pStr);
int Open(const char *pathname, int oflag, mode_t mode);
int Close(int fd);
pid_t Fork(void);
int Pipe(int *fds);
Sigfunc * Signal(int signo, Sigfunc *func);
void * Malloc(size_t size);

/* error.c */
void err_ret(const char *fmt, ...);
void err_sys(const char *fmt, ...);
void err_dump(const char *fmt, ...);
void err_msg(const char *fmt, ...);
void err_quit(const char *fmt, ...);
void errToSyslog(int i);
void terminateProg(int ret);

/* getparam.c */
int OpenConfFile(void);
void CloseConfFile(void);
char *GetConfValue(char *name);
void  InitConf();
char *GetNextConfValue(void);

/* pcap.c */
int InitPcap(void);
int GetNextPacketFromPcap(char* ipAddress, char* macAddress, int* pTtl);
void ClosePcap(void);
int GetMyMacAddress(char* macAddress);

/* addrcache.c */
void InitIpCache(void);
int IsRecentlyCheckedIp(char* ipAddress);
void FreeIpCache(void);
void Freequeue(void);

/* managementdb.c */
int InitMngDb(void);
int QueryMacFromMngDb(char* macAddress, char* userid, char* extraid);
void CloseMngDb(void);
int PutCloseToMngDb(char* ipAddress);
int PutOpenToMngDb(char* macAddress, char* ipAddress);

/* workdb.c */
int InitWorkDb(void);
int InsertSessionToWorkDb(char* ipAddr, char* userId, char* extraId, 
			char* macAddr, int ruleNumber);
int DelSessionFromWorkDb(char* ipAddr);
int GetSessionFromWorkDb(char* ipAddr, char* userId, char* extraId, 
			 int* openTime, int* checkTime, char *macAddr,
			   int* ruleNumber);
int UpdateCheckTimeInWorkDb(char* ipAddr);
int DelUselessSessionsInWorkDb(int delayed);
int GetSessionTableFromWorkDb(DB* sessionTable);
int GetSessionTableFromOpengateWorkDb(DB* sessionTable);
int PutMacInfoToWorkDb(char* macAddress, int ttl, int isNat);
int IsActiveRuleInOpengateWorkDb(int ruleNumber);
int SetCloseTimeToOpengateWorkDb(char* ipAddress);
int GetSessionFromOpengateWorkDb(char* ipAddress, char* userid, char* openTime,
				 char *macAddress, int* ruleNumber);

/* sessionctrl.c */
int AddSession(char* ipAddress, char* macAddress, char* userId, char* extraId);
void DelSession(char* ipAddress);
void RenewSession(char* ipAddress);
void DelUselessSessions(void);
void DelAllSessions(void);
int CloseSession(void* pParam, int argc, char *argv[], char* colName[]);
int IsMatchedSessionFound(char* ipAddress, char* macAddress);
void CloseUnmatchSessions(void);
void WriteOpenToSyslog(char* userId, char* extraId, char* ipAddress, char* macAddress);
void WriteCloseToSyslog(char* userId, char* extraId, char* ipAddress, char* macAddress, int openTime);

/* ttlcheck.c */
int InitTtlCheck(void);
int IsSentViaNatOrRouter(char* ipAddress, char* macAddress, int ttl);
void PutLogAtNatOrRouter(int isNatOrRouter, char* ipAddress, char* macAddress, int ttl);
