/**************************************************
opengate Mac addr auth program

 module to control management database
 list of mac addresses
 list of usage log
 implemented with MySql 

Copyright (C) 2011 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/
#include "opengatemd.h"
#include <mysql.h>


MYSQL mysql;

/******************************************
initialize management db
******************************************/
int initMngDb(void){

  /* set parameters */
  char *server = GetConfValue("MySqlDb/Server");
  char *user =  GetConfValue("MySqlDb/User");
  char *password = GetConfValue("MySqlDb/Password");
  char *database = GetConfValue("MySqlDb/Database");
  my_bool reconnect;

/* initialize mysql */
  mysql_library_init(-1,NULL,NULL);
  if(mysql_init(&mysql)==NULL){
     err_msg("ERR at %s#%d: mysql init: %s",__FILE__,__LINE__,
	     mysql_error(&mysql));
     terminateProg(0);
  }

  /* Connect to database */
  if (!mysql_real_connect(&mysql, server,
			   user, password, database, 0, NULL, 0)) {
    err_msg("ERR at %s#%d: mysql connect: %s",__FILE__,__LINE__,
	     mysql_error(&mysql));
    terminateProg(0);
  }

  /* set auto-reconnect true */
  reconnect = TRUE;
  mysql_options(&mysql, MYSQL_OPT_RECONNECT, &reconnect);  

  return TRUE;
}

/******************************************
close management db
******************************************/
void closeMngDb(void){
  mysql_close(&mysql);
  mysql_library_end();
}

/******************************************
query data from management db
input=macAddress,output=others
******************************************/
int queryMacFromMngDb(char* macAddress, char* userId, char* extraId){
  MYSQL_RES *res;
  MYSQL_ROW row;
  int found=FALSE;
  char queryStr[BUFFMAXLN];

  /* set default values userId="?", extraId=""  */
  userId[0]='?'; userId[1]='\0'; extraId[0]='\0';
 
  /* prepare query string */
  snprintf(queryStr, BUFFMAXLN, 
	   "select userId,extraId from macaddrs "
	   "where macAddress='%s' and status='A' and limitDate>now()",
	   macAddress);

  /* send SQL query */
  if (mysql_query(&mysql, queryStr)){
     err_msg("ERR at %s#%d: mysql query: %s",__FILE__,__LINE__,
	     mysql_error(&mysql));
     return FALSE;
  }

  res = mysql_use_result(&mysql);
  
  /* output table name */
  row = mysql_fetch_row(res);

  /* if not found, return false */
  if(row==NULL)  found=FALSE;

  /* if found */
  else {
    strcpy(userId, row[0]);
    strcpy(extraId,row[1]);
    found=TRUE;
  }

  mysql_free_result(res);
  return found;
}

/******************************************
put open log to management db 
******************************************/
int putOpenToMngDb(char* macAddress, char* ipAddress){

  char queryStr[BUFFMAXLN];
  struct utsname uts;

  /* get domain name */
  uname(&uts);

  /* prepare query string */
  snprintf(queryStr, BUFFMAXLN, 
	   "insert into sessionmd "
	   "(macAddress, ipAddress, gatewayName, openTime, closeTime) "
	   "values ('%s','%s','%s', now(), 0)",
	   macAddress, ipAddress, uts.nodename);

  /* send SQL query */
  if (mysql_query(&mysql, queryStr)){
     err_msg("ERR at %s#%d: mysql query: %s",__FILE__,__LINE__,
	     mysql_error(&mysql));
     return FALSE;
  }

  return TRUE;
}

/******************************************
put close log to management db
******************************************/
int putCloseToMngDb(char* ipAddress){

  char queryStr[BUFFMAXLN];

  /* prepare query string */
  snprintf(queryStr, BUFFMAXLN, 
	   "update sessionmd set closeTime=now() "
	   "where ipAddress='%s' and closeTime=0", ipAddress);

  /* send SQL query */
  if (mysql_query(&mysql, queryStr)){
     err_msg("ERR at %s#%d: mysql query: %s",__FILE__,__LINE__,
	     mysql_error(&mysql));
     return FALSE;
  }

  return TRUE;

}

/********************************************
 routines for debugging output
********************************************/
int QueryMacFromMngDb(char* macAddress, char* userId, char* extraId){
  int ret;
  if(debug>1) err_msg("DEBUG:=>queryMacFromMngDb(%s)", macAddress);
  ret = queryMacFromMngDb(macAddress, userId, extraId);
  if(debug>1) err_msg("DEBUG:(%d)<=queryMacFromMngDb(,%s,%s)",ret,userId,extraId);
  return ret;
}
int InitMngDb(void){
  int ret;
  if(debug>1) err_msg("DEBUG:=>initMngDb()");
  ret=initMngDb();
  if(debug>1) err_msg("DEBUG:(%d)<=closeMngDb()",ret);
  return ret;
}
void CloseMngDb(void){
  if(debug>1) err_msg("DEBUG:=>closeMngDb()");
  closeMngDb();
  if(debug>1) err_msg("DEBUG:<=closeMngDb()");
}

int PutCloseToMngDb(char* ipAddress){
  int ret;
  if(debug>1) err_msg("DEBUG:=>putCloseToMngDb(%s)", ipAddress);
  ret = putCloseToMngDb(ipAddress);
  if(debug>1) err_msg("DEBUG:(%d)<=putCloseToMngDb()",ret);
  return ret;
}
int PutOpenToMngDb(char* macAddress, char* ipAddress){
  int ret;
  if(debug>1) err_msg("DEBUG:=>putOpenToMngDb(%s,%s)", macAddress, ipAddress);
  ret = putOpenToMngDb(macAddress, ipAddress);
  if(debug>1) err_msg("DEBUG:(%d)<=putOpenToMngDb()",ret);
  return ret;
}

