/**********************************************************/
/* output error message to syslog or stdout               */
/*  from UNIX NETWORK PROGRAMMING,Vol.1,Second Edition,   */
/*      By W. Richard Stevens, Published By Prentice Hall */
/*       ftp://ftp.kohala.com/pub/rstevens/unpv12e.tar.gz */
/**********************************************************/

#include "opengatemd.h"
#include	<stdarg.h>		/* ANSI C header file */
#include	<syslog.h>		/* for syslog() */

int		daemon_proc;

static void	err_doit(int, int, const char *, va_list);

/*************************************************/
/* Nonfatal error related to a system call.
 * Print a message and return. */
/*************************************************/
void errToSyslog(int i)
{
  daemon_proc=i;
}

void
err_ret(const char *fmt, ...)
{
	va_list		ap;

	va_start(ap, fmt);
	err_doit(1, LOG_INFO, fmt, ap);
	va_end(ap);
	return;
}

/*************************************************/
/* Fatal error related to a system call.
 * Print a message and terminate. */
/*************************************************/
void
err_sys(const char *fmt, ...)
{
	va_list		ap;

	va_start(ap, fmt);
	err_doit(1, LOG_ERR, fmt, ap);
	va_end(ap);
	exit(1);
}

/*************************************************/
/* Fatal error related to a system call.
 * Print a message, dump core, and terminate. */
/*************************************************/
void
err_dump(const char *fmt, ...)
{
	va_list		ap;

	va_start(ap, fmt);
	err_doit(1, LOG_ERR, fmt, ap);
	va_end(ap);
	abort();		/* dump core and terminate */
	exit(1);		/* shouldn't get here */
}

/*************************************************/
/* Nonfatal error unrelated to a system call.
 * Print a message and return. */
/*************************************************/
void
err_msg(const char *fmt, ...)
{
	va_list		ap;

	va_start(ap, fmt);
	err_doit(0, LOG_INFO, fmt, ap);
	va_end(ap);
	return;
}

/*************************************************/
/* Fatal error unrelated to a system call.
 * Print a message and terminate. */
/*************************************************/
void
err_quit(const char *fmt, ...)
{
	va_list		ap;

	va_start(ap, fmt);
	err_doit(0, LOG_ERR, fmt, ap);
	va_end(ap);
	exit(1);
}


/*************************************************/
/* Print a message and return to caller.
 * Caller specifies "errnoflag" and "level". */
/*************************************************/
static void
err_doit(int errnoflag, int level, const char *fmt, va_list ap)
{
	int		errno_save, n;
	char	buf[BUFFMAXLN];

	errno_save = errno;		/* value caller might want printed */
#ifdef	HAVE_VSNPRINTF
	vsnprintf(buf, sizeof(buf), fmt, ap);	/* this is safe */
#else
	vsprintf(buf, fmt, ap);					/* this is not safe */
#endif
	n = strlen(buf);
	if (errnoflag)
		snprintf(buf+n, sizeof(buf)-n, ": %s", strerror(errno_save));
	strcat(buf, "\n");

	if (daemon_proc) {
		syslog(level, buf);
	} else {
		fflush(stdout);		/* in case stdout and stderr are the same */
		fputs(buf, stderr);
		fflush(stderr);
	}
	return;
}


/*************************************
put out end message and exit 
*************************************/
void terminateProg(int ret){
  if(debug>0) err_msg("INFO: Terminated");
  exit(ret);
}


