/**************************************************
Opengate authentication CGI main

This program is accessed as [http(s)://xx.yy/opengateauth.cgi?0-0-0&ja]
It send out the authentication page after keywords replacement.

Copyright (C) 2005 Opengate Project Team
Written by Katsuhiko Eguchi, 2005 
Modified by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include "opengatesrv.h"

int  main(int argc, char **argv)
{
  
  char htmlFile[BUFFMAXLN]="";   /* html file */
  char lang[WORDMAXLN]="";       /* language */
  char clientAddr[ADDRMAXLN]=""; /* client ip address */
  char paramString[BUFFMAXLN]="";   /* parameters in html access */
  char* pLang="";  /* pointer to language string */ 
  char* pAddr4=""; /* pointer to addr4 string */
  char* pUrl="";   /* potinter to redirected URL string */
  char authCgiUrl[BUFFMAXLN];  /* url of opengateauth.cgi */
  char mainCgiUrl[BUFFMAXLN];  /* url of opengatesrv.cgi */
  char durationMax[WORDMAXLN]; /* usage duration maximum */
  char opengateServerName[BUFFMAXLN];  /* opengate server domain name */
  char opengateDir[BUFFMAXLN];   /* opengate doc directory in httpd doc */
  char userid[USERMAXLN]; /* userid value */
  char cookie[SIDMAXLN]; /* HTTP-Cookie value */
  char protocol[WORDMAXLN]; /* http or https */
  char redirectedUrl[BUFFMAXLN]; /* redirected(requested before fwd) URL */
  char *name[1];
  char *value[1];
  char *next[1];
  char *ptr;
  char *authProtocol;

  /* keyword pairs */
  /*  the left key is replaced by the right value */
  struct html_key keys[]=
    {
      {"%%OPENGATESERVERNAME%%", opengateServerName},
      {"%%OPENGATEDIR%%", opengateDir},
      {"%%AUTHCGIURL%%", authCgiUrl},
      {"%%CGIURL%%", mainCgiUrl},
      {"%%ADDR4%%", clientAddr},
      {"%%DURATIONMAX%%",durationMax},
      {"%%PROTOCOL%%",protocol},
      {"%%REDIRECTEDURL%%",redirectedUrl},
      {"%%LANGUAGE%%",lang},
      {"",""}  /* DON'T REMOVE THIS LINE */
    };

  /* if this is executed in shell with '-v' option, show make dir */  
  if(argc>1 && strcmp(argv[1],"-v")==0){
    printf("makedir: %s\n", MAKEDIR);
    exit(0);
  }

  /* prepare config file */
  if(OpenConfFile()==-1) return 0;
 
  /* start log */
  errToSyslog(atoi(GetConfValue("Syslog/Enable")));
  openlog(GetConfValue("AuthCgi"), LOG_PID, atoi(GetConfValue("Syslog/Facility")));

  /* initialize config */
  InitConf();

  if(debug>1) err_msg("DEBUG: started");

  snprintf(opengateServerName,BUFFMAXLN,"%s",GetConfValue("OpengateServerName"));
  snprintf(opengateDir,BUFFMAXLN,"%s",GetConfValue("OpengateDir"));

  /* create URL string */
  snprintf(authCgiUrl, BUFFMAXLN, "%s%s%s/%s",
	   opengateServerName,
	   GetConfValue("CgiDir"),
	   opengateDir,
	   GetConfValue("AuthCgi"));
  snprintf(mainCgiUrl, BUFFMAXLN, "%s%s%s/%s",
	   opengateServerName,
	   GetConfValue("CgiDir"),
	   opengateDir,
	   GetConfValue("MainCgi"));
  
  /* setup usage duration maximum and default (saved as seconds) */
  snprintf(durationMax,WORDMAXLN,"%d",
	   atoi(GetConfValue("Duration/Max"))/60);

  /* get paremeters, */
  if(!isNull(getenv("QUERY_STRING"))){

    /* get html access parameter string (attached at the end of url) */
    strlcpy(paramString, getenv("QUERY_STRING"), BUFFMAXLN);
  }

  /* split language and address in paramString
     [addr=0-0-0&lang=ja&redirectedurl=xxxx] */
  ptr=paramString;
  while(ptr!=NULL){
    split(ptr, name, value, next);
    if(strstr(name[0], "addr")!=NULL){
      pAddr4=value[0];
    }else if(strstr(name[0], "lang")!=NULL){
      pLang=value[0];
    }else if(strstr(name[0], "redirectedurl")!=NULL){
      pUrl=value[0];
    }
    ptr=next[0];
  }

  /* copy clientAddr(encoded) */
  if(isNull(pAddr4)){
    clientAddr[0]='\0';
  }else{
    strlcpy(clientAddr, pAddr4, ADDRMAXLN);
  }

  /* get language and check its correctness */
  if(!isNull(pLang) && strstr(GetConfValue("HtmlLangs"), pLang)!=NULL){

    /* if corrrect, set it */
    strlcpy(lang, pLang, WORDMAXLN);
  }else{

    /* if not correct, get default language at the top of lang list */
    sscanf(GetConfValue("HtmlLangs"), "%s", lang);
  }

  /* copy redirected URL */
  strlcpy(redirectedUrl, pUrl, BUFFMAXLN);

  /* send out header */
  printf("Content-Type: text/html\r\n\r\n");

  /* construct html file path */
  sprintf(htmlFile, "%s%s/%s/", GetConfValue("DocumentRoot"),
	  opengateDir, lang);

  /*** if http-cookie exists or auth by shibboleth/httpbasic */
  /* skip authenticaion */
  authProtocol=GetConfValue("AuthServer/Protocol");
  if(((*GetConfValue("EnableCookieAuth")!='0') && GetAuthCookie(cookie,userid))
     || strcmp(authProtocol, "shibboleth")==0 
     || strcmp(authProtocol, "httpbasic")==0 ){

    strlcat(htmlFile, GetConfValue("SkipAuthDoc"), BUFFMAXLN);

    /* ssl or non-ssl protocol  */
    if(!isNull(getenv("SERVER_PORT"))
       && strcmp(getenv("SERVER_PORT"),GetServicePortStr("https"))==0) {
      strlcpy(protocol, "https", WORDMAXLN);
    }else{
      strlcpy(protocol, "http", WORDMAXLN);
    }
  }
  
  /*** otherwise, request userid and password */
  else{
    /* ssl or non-ssl file */
    if(!isNull(getenv("SERVER_PORT"))
       && strcmp(getenv("SERVER_PORT"),GetServicePortStr("https"))==0) {
      strlcat(htmlFile, GetConfValue("AuthDocSsl"), BUFFMAXLN);
    }else{
      strlcat(htmlFile, GetConfValue("AuthDoc"), BUFFMAXLN);
    }
  }

  /* replace keywords and send out */
  HtmlTemplate(htmlFile, keys);

  if(debug>1) err_msg("DEBUG: terminated");  

  return 0;
}
