/**************************************************
opengate server main

Copyright (C) 1999 Opengate Project Team
Written by Katsuhiko Eguchi, 2005 
Modified by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include	"opengatesrv.h"

/********************/
/* Get Mac Address  */
/********************/
void getMacAddr(char *clientAddr4, char *macAddr4, char *clientAddr6, char *macAddr6, int ipStatus)
{
  switch(ipStatus){
  case IPV46DUAL:
    GetMacAddrFromArp(clientAddr4,macAddr4);
    GetMacAddrFromNdp(clientAddr6,macAddr6);
    break;

  case IPV4ONLY:
    GetMacAddrFromArp(clientAddr4, macAddr4);
    ReFormatMacAddr(macAddr4,macAddr6);
    break;

  case IPV6ONLY:
    GetMacAddrFromNdp(clientAddr6, macAddr6);
    break;

  default:
    err_msg("ERR at %s#%d: Cannot recognize IP versions=%d for %s and %s",
	    __FILE__,__LINE__,ipStatus,clientAddr4,clientAddr6);

  }
  
  return;
}

/************************************/
/* arp form is reformed to ndp form */ 
/* format macAddr for ndp or arp    */
/* match the form of two program    */
/* mac addr by arp 00:01:12:0b:..   */
/* mac addr by ndp 0:1:12:b:..      */
/************************************/
void reFormatMacAddr(char* macAddr4, char* macAddr6)
{
  char *strp = NULL;
  char delims[] = ":";
  char buf[ADDRMAXLN] = "";

  strcpy(macAddr6,"");
  strcpy(buf,macAddr4);
  strp=strtok(buf,delims);
  
  if(strncmp(strp,"0",1)==0){
    strp++;
    strcat(macAddr6,strp);
  }else{
    strcat(macAddr6,strp);
  }

  strp=strtok(NULL,delims);
  while(strp!=NULL){
    strcat(macAddr6,delims);
    if(strncmp(strp,"0",1)==0){
      strp++;
      strcat(macAddr6,strp);
    }else{
      strcat(macAddr6,strp);
    }
    strp=strtok(NULL,delims);
  }
}

/**********************************************************/
/* check the mac address form arp and ndp are same or not */
/**********************************************************/
int isSameMacAddr(char* macAddr4, char* macAddr6){

  char macAddrConvert[ADDRMAXLN];

  ReFormatMacAddr(macAddr4, macAddrConvert);
  if(strcmp(macAddrConvert, macAddr6)==0) return TRUE;
  else return FALSE;
}
  

/*****************************************************/
/*****************************************************/
void ReFormatMacAddr(char* macAddr4, char* macAddr6)
{
  if(debug>1) err_msg("DEBUG:=>reFormatMacAddr(%s)", macAddr4);
  reFormatMacAddr(macAddr4, macAddr6);
  if(debug>1) err_msg("DEBUG:<=reFormatMacAddr(%s)", macAddr6);
}

void GetMacAddr(char *clientAddr4, char *macAddr4, char *clientAddr6, char *macAddr6, int ipStatus)
{
  if(debug>1) err_msg("DEBUG:=>getMacAddr(%s,,%s,,%d)",clientAddr4,clientAddr6,ipStatus);
  getMacAddr(clientAddr4,macAddr4,clientAddr6,macAddr6, ipStatus);
  if(debug>1) err_msg("DEBUG:<=getMacAddr(,%s,,%s)", macAddr4, macAddr6);
}

int IsSameMacAddr(char* macAddr4, char* macAddr6){
  int ret;

  if(debug>1) err_msg("DEBUG:=>isSameMacAddr(%s,%s)",macAddr4,macAddr6);
  ret=isSameMacAddr(macAddr4,macAddr6);
  if(debug>1) err_msg("DEBUG:(%d)<=isSameMacAddr( )",ret);

  return ret;
}
  
