/**************************************************
opengate server
 module for communication with arp 

Copyright (C) 1999 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include "opengatesrv.h"

/*******************************************************************/
/* get MAC address for clientAddr (nnn.nnn.nnn.nnn) by arp request */
/*******************************************************************/
int getMacAddrFromArp(char *clientAddr4, char* macAddr4)
{
  char buf[BUFFMAXLN];
  char *startp;
  char *endp;
  FILE *fpipe;

  macAddr4[0]='?';
  macAddr4[1]='\0';

  /* exec arp */
  if( (fpipe=Popenl(1, "r", GetConfValue("ArpPath"), "-n", 
		    clientAddr4, (char *)0)) == NULL){ 
    err_msg("ERR at %s#%d: exec arp -n error",__FILE__,__LINE__);
    return -1;
  }
  
  /* get arp response */  
  if(fgets(buf, BUFFMAXLN, fpipe)==NULL){
    err_msg("ERR at %s#%d: readin error",__FILE__,__LINE__);
    Pclose(fpipe);
    return -1;
  } 

  /* close pipe */
  Pclose(fpipe);

  /* arp response takes following format           */
  /* "? (133.49.22.1) at 8:0:20:a5:4:62 [ethernet]"*/
  /* get MAC address from above string             */
  if((startp=strstr(buf," at "))==NULL) return -1;

  startp=startp+4;
  if((endp=strstr(startp, " "))==NULL) return -1;

  /* cut off string at endp */
  *endp='\0';

  /* return if invalid address */
  if((strstr(startp, ":"))==NULL) return -1;

  /* save to macAddr4 */
  strlcpy(macAddr4, startp, ADDRMAXLN);
    
  return 0;
}


/****************************************/
/****************************************/
int GetMacAddrFromArp(char *clientAddr4, char* macAddr4)
{
  int ret;

  if(debug>1) err_msg("DEBUG:=>getMacAddrFromArp(%s,)",clientAddr4);
  ret=getMacAddrFromArp(clientAddr4,macAddr4);
  if(debug>1) err_msg("DEBUG:(%d)<=getMacAddrFromArp(,%s)",ret,macAddr4);

  return ret;
}  
