/**************************************************
addr-convert

Address(Ipv4) encode and decode routines
At now, the encoding is reverse order packing of four decimals 

Copyright (C) Opengate Project Team
Written by Yoshiaki Watanabe 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/
#include "opengatesrv.h"

/*****************************************************/
/* Address encoding (A.B.C.D => DCBA-c c:checkdigit) */
/*****************************************************/
int addrEncode(char encodeAddr[], char dotSepAddr[])
{
  int ad[4];
  unsigned long address;
  int illform=0;
  int i;
  int checkDigit;

  /* get 4 decimal from address string */
  if(sscanf(dotSepAddr, "%d.%d.%d.%d",&ad[3],&ad[2],&ad[1],&ad[0])!=4){
    illform=1;
  }

  /* packing to an integer */
  address=0;
  for(i=0;i<4;i++){
    if(ad[i]<0 || ad[i]>255) illform=1;
    address=address*256+ad[i];
  }

  /* calculate check digit */
  checkDigit = (ad[0]*7 + ad[1]*5 + ad[2]*3 + ad[3]) % 11;

  /* convert from integer to string */
  /* the string has the from as [encodeAddress-checkDigit-TimeNow] */
  if(!illform){
    snprintf(encodeAddr, ADDRMAXLN,
	     "%lu-%d-%d", address,checkDigit, (int)time(NULL));
  }else{
    strlcpy(encodeAddr, "0-0-0", ADDRMAXLN);
  }

  return illform;
}

/*****************************************************/
/* Address decoding (DCBA-c => A.B.C.D) c:checkdigit */
/*****************************************************/
int addrDecode(char dotSepAddr[], char encodeAddr[])
{

  int i;
  int ad[4];
  unsigned long address;
  int illform=0;
  int checkDigit;
  /* on 64 bit machines time_t and int are different, to read a correct */
  /* value with sscanf() we declare encodeTiming and diffTime as int    */
  /* and later on cast time(NULL) to int                                */
  /* this should work on 32 and 64 bit                                  */
  /* WARNING: this is WILL fail in the year 2038!                       */
  /* Fri Feb 29 00:42:57 CET 2008 // ob@sysadm.in                       */
  /* time_t encodeTiming, diffTime; */
  int encodeTiming, diffTime;

  /* convert string to integer */
  if(sscanf(encodeAddr, "%lu-%d-%d", &address, &checkDigit, &encodeTiming)!=3){
    illform=1;
  }

  /* if(debug>1) err_msg("DEBUG:AddrDecode encodeTiming=%d", encodeTiming); */
  /* if the time difference between encode and decode is too large, retry */
  diffTime = (int)time(NULL) - encodeTiming;
  if(diffTime <0 || diffTime > atoi(GetConfValue("ForwardingDelay"))){
    illform = 1;
  }
  
  /* divide ineger to four 8bits decimals */
  for(i=3;i>=0;i--){
    ad[i]=address%256;
    address/=256;
  }

  /* check the checkdigit value */
  if(checkDigit != (ad[0]*7 + ad[1]*5 + ad[2]*3 + ad[3]) % 11){
    illform=1;
  }

  /* convert to dot separated address string */
  if(!illform){
    snprintf(dotSepAddr, ADDRMAXLN, "%d.%d.%d.%d", ad[3], ad[2], ad[1], ad[0]);
  }else{
    dotSepAddr[0]='\0';
  }

  return illform;
}

int AddrEncode(char encodeAddr[], char dotSepAddr[]){
  int ret;
  if(debug>1) err_msg("DEBUG:=>addrEncode(,%s)",dotSepAddr);
  ret = addrEncode(encodeAddr, dotSepAddr);
  if(debug>1) err_msg("DEBUG:(%d)<=addrEncode(%s,)",ret,encodeAddr);
  return ret;
}

int AddrDecode(char dotSepAddr[], char encodeAddr[]){
  int ret;
  if(debug>1) err_msg("DEBUG:=>addrDecode(,%s)",encodeAddr);
  ret = addrDecode(dotSepAddr, encodeAddr);
  if(debug>1) err_msg("DEBUG:(%d)<=addrDecode(%s,)",ret,dotSepAddr);
  return ret;
}
