//<!--
var httpkeepUrl;
var appletDescription;
var httpObj;
var nextKey;
var nowKey;
var sessionId;
var keepConnect;
var cookieName;
var retryCount;
var urlString;
var timer;

// debug print procedure
function debugPrint(str){
    var out = document.getElementById("debug");
    if(!out) return;
    out.innerHTML += getHourMinutes() + str + "<br>";
}

// reset http object
function resetHttp(){
    if(httpObj!=null){
	httpObj.abort();
	httpObj=null;
    }
}

// get time now as [hh:mm]
function getHourMinutes(){
    today=new Date; 
    hh=today.getHours();  mm=today.getMinutes();
    if(hh<10)hh='0'+hh;   if(mm<10)mm='0'+mm;
    return hh+":"+mm;
}

// create http request object
function createXMLHttpRequest() {
    try { return new ActiveXObject("Msxml2.XMLHTTP");    } catch(e) {}
    try { return new ActiveXObject("Microsoft.XMLHTTP"); } catch(e) {}
    try { return new XMLHttpRequest();                   } catch(e) {}
    return null;
}

// send ajax request [hello] to the server 
function sendHello(){

    // set timer to detect no response
    if(timer)clearTimeout(timer);
    timer=setTimeout("reSendHello()",120000);

    // ajax communication
    if((httpObj=createXMLHttpRequest())!=null){
	httpObj.onreadystatechange = displayResponse;
	
	// prepare request string and renew keys
	// if communication is failed, retry with the key same as previous
	// and try with updated key
	if(retryCount==0 || retryCount>5){
	    urlString=httpkeepUrl+"-"+nowKey+"-"+hex_md5(nextKey+sessionId);
	    nowKey=nextKey;
	    rand=Math.random();
	    nextKey=hex_md5(String(rand));
	    retryCount=0;
	}

	// send ajax request
	try{  
	    httpObj.open("GET", urlString ,true);
	    httpObj.send(null);
	}
	// if failed, retry after 1 sec
	catch(e){
	    if(timer) clearTimeout(timer);
	    timer=setTimeout("reSendHello()",1000);
	    showError("1");
	}
    }

    // if failed, retry after 1 sec
    else{
	if(timer) clearTimeout(timer);
	timer=setTimeout("reSendHello()",1000);
	showError("2");
    }
}

// called at reply for ajax request
function displayResponse(){

    // get response
    try{

	// if normal response, update time on web page and send next hello
	if(httpObj.readyState==4){
	    if(httpObj.status==200){
		document.getElementById("dispmsg").innerHTML = getHourMinutes();
		document.getElementById("dispmsg").style.backgroundColor = "yellow";
		retryCount=0;
		sendHello();
	    }
	    // if abnormal response, retry after 1 sec
	    else{
		if(timer) clearTimeout(timer);
		timer=setTimeout("reSendHello()",1000);
		showError("3");
	    }
	}
    }
    // if failed, retry afer 1 sec
    catch(e){
	if(timer) clearTimeout(timer);
	timer=setTimeout("reSendHello()",1000);
	showError("4");
    }
}

// at communication error, reset and retry sending
function reSendHello(){
    resetHttp();
    retryCount++;
    sendHello();
}

// show error on web page
function showError(msg){
    document.getElementById("dispmsg").innerHTML = "Error(" + msg + ") " + getHourMinutes();
    document.getElementById("dispmsg").style.backgroundColor = "pink";
    keepConnect=false;
}

// clear http cookie
function clearCookie(){
    if(keepConnect){
	document.cookie = cookieName+"=;";
    }
}

// finishing procedure
function endHttpkeep(){
    
    //clear cookie
    clearCookie(); 
    
    if(httpObj!=null){
	httpObj.abort();
    }
}

// initializing procedure called from web page
function initHttpkeep(urlArg, sid, ckName)
{
    
    // save arguments
    httpkeepUrl=urlArg;
    nowKey=hex_md5(sid);
    cookieName=ckName;
    sessionId=sid;
    rand=Math.random();
    nextKey=hex_md5(String(rand));
    keepConnect=true;
    retryCount=0;

    // set timeout and send hello 
    sendHello();
}
//-->
