/**************************************************
opengate forwarding CGI main

 Program responding to the first forwarding HTTP access.
 DocumentRoot/index.html.var must be set to start this program
 at forwarding HTTP access from IPFW.

---sample index.himl.var---
URI: /cgi-bin/opengate/opengatefwd.cgi?en
Content-language: en
Content-type: text/html

URI: /cgi-bin/opengate/opengatefwd.cgi?ja
Content-language: ja
Content-type: text/html

URI: /cgi-bin/opengate/opengatefwd.cgi?en
Content-type: text/html
---------------------------

Copyright (C) 2006 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include "opengatesrv.h"

int  main(int argc, char **argv)
{
  char htmlFile[BUFFMAXLN]="";   /* html file */
  char clientAddr[ADDRMAXLN]=""; /* client ip address */
  char encodeAddr[ADDRMAXLN]=""; /* encoded ip address */
  char lang[ADDRMAXLN]=""; /* client language */
  char authCgiUrl[BUFFMAXLN];  /* url of opengateauth.cgi */
  char redirectedUrl[BUFFMAXLN]; /* url of redirected(requested) page */
  char *protocol;
  char *httpHost;
  char *requestUri;

  /* keyword pairs */
  /*  the left key is replaced by the right value */
  struct html_key keys[]=
    {
      {"%%ADDR4%%", encodeAddr},
      {"%%AUTHCGIURL%%", authCgiUrl},
      {"%%REDIRECTEDURL%%", redirectedUrl},
      {"",""}  /* DON'T REMOVE THIS LINE */
    };

  /* prepare config file */
  if(OpenConfFile()==-1)return 0;
 
  /* start log */
  errToSyslog(atoi(GetConfValue("Syslog/Enable")));
  openlog(GetConfValue("FwdCgi"), LOG_PID, atoi(GetConfValue("Syslog/Facility")));

  /* initialize config */
  InitConf();

  if(debug>1) err_msg("DEBUG: started");

  /* favicon.ico request is ignored */
  if(!isNull(getenv("REQUEST_URI"))){
    if(strcmp(getenv("REQUEST_URI"), "/favicon.ico")==0){
      PutClientMsg("");
      return 0;
    }
  }

  /* create authcgi URL string */
  snprintf(authCgiUrl, BUFFMAXLN, "%s%s%s/%s",
	   GetConfValue("OpengateServerName"),
	   GetConfValue("CgiDir"),
	   GetConfValue("OpengateDir"),
	   GetConfValue("AuthCgi"));

  /* get lang from httpd */
  if(isNull(getenv("QUERY_STRING"))){
    lang[0]='\0';
  }else{
    strncpy(lang, getenv("QUERY_STRING"), ADDRMAXLN);
  }
     
  /* if not get, use default lang at the top of lang list */
  if(isNull(lang)){
    sscanf(GetConfValue("HtmlLangs"),"%s",lang);
  }
     
  /* if the lang is not registered in lang list, set the default lang */
  else if(strstr(GetConfValue("HtmlLangs"), lang)==NULL){
    sscanf(GetConfValue("HtmlLangs"),"%s",lang);
  }

  /* get client address */
  if(isNull(getenv("REMOTE_ADDR"))){
    clientAddr[0]='\0';
  }else{
    strncpy(clientAddr,getenv("REMOTE_ADDR"),ADDRMAXLN);
  }

  /* encode the address(if IPv6 addr, fail) */
  if(AddrEncode(encodeAddr, clientAddr)==1){
    encodeAddr[0]='\0';
  }

  /* construct redirected(requested) URL */
  /* protocol */
  if(!isNull(getenv("SERVER_PORT"))
     && strcmp(getenv("SERVER_PORT"),GetServicePortStr("https"))==0) {
    protocol="https";
  }else{
    protocol="http";
  }
  /* http-host */
  if(!isNull(getenv("HTTP_HOST"))) httpHost=getenv("HTTP_HOST");
  else httpHost="";

  /* request-uri */
  if(!isNull(getenv("REQUEST_URI"))) requestUri=getenv("REQUEST_URI");
  else requestUri="";

  /* concat above items to make redirect URL */
  if(!isNull(httpHost)){
    snprintf(redirectedUrl,BUFFMAXLN,"%s://%s%s", protocol,httpHost,requestUri);
  }else redirectedUrl[0]='\0';

  /* construct readin html file path */
  snprintf(htmlFile, BUFFMAXLN, "%s%s/%s/%s", 
	  GetConfValue("DocumentRoot"), 
	  GetConfValue("OpengateDir"),
	  lang, 
	  GetConfValue("FwdDoc"));

  /* send out header */
  printf("Content-Type: text/html\r\n\r\n\r\n");

  /* relpace keywords and send out */
  HtmlTemplate(htmlFile, keys);

  if(debug>1) err_msg("DEBUG: terminated");

  return 0;
}
