/*************************************************
  opengate server
   module for Controlling user DB 

**************************************************/
#include "opengatesrv.h"
#include <sqlite3.h>


/**************************************************************/
/* write session info to session control database at start    */ 
/**************************************************************/
int putSessionBeginToDb(char* cookie, char* userid, 
			char* clientAddr4, char* clientAddr6, 
			char* macAddr4, 
			char* ruleNumber4, char* ruleNumber6,
			int duration, int durationEntered,
			int cookieAuth, char *language){

  int rc;
  sqlite3 *db;
  char *pErrMsg;
  /* SQL CREATE COMMAND */
  char *createCmd="CREATE TABLE session (cookie TEXT PRIMARY KEY,\
 userid TEXT, pid INTEGER, openTime TEXT, closeTime TEXT,\
 clientAddr4 TEXT, clientAddr6 TEXT, macAddr TEXT,\
 ruleNumber4 INTEGER, ruleNumber6 INTEGER,duration INTEGER,\
 durationEntered INTEGER, cookieAuth INTEGER, language TEXT, watchMode TEXT)";

  /* SQL INSERT COMMAND, where %x is replaced in snprintf */
  char *insertFormat="INSERT INTO session\
 (cookie, userid, pid, openTime, closeTime,\
 clientAddr4, clientAddr6, macAddr, ruleNumber4, ruleNumber6,\
 duration, durationEntered, cookieAuth, language, watchMode)\
 values ('%s','%s',%d,\
 datetime(%d,'unixepoch','localtime'),\
 '-','%s','%s','%s', '%s', '%s', %d, %d, %d, '%s', '-')";
  char *insertCmd;
  int resultFlag=TRUE;
  
  /* Open sqlite */
  if(sqlite3_open(GetConfValue("SqliteDb"),&db)!=SQLITE_OK){
    err_msg("ERR at %s#%d: sqlite3_open",__FILE__,__LINE__);
    sqlite3_close(db);
    return FALSE;
  }
  
  /* Prepare insert command */
  insertCmd=sqlite3_mprintf(insertFormat,cookie,userid, 
			    getpid(),time(NULL),clientAddr4,clientAddr6, 
			    macAddr4,ruleNumber4,ruleNumber6,
			    duration,durationEntered,cookieAuth,language);

  /* Execute insert to sqlite */
  if((rc=sqlite3_exec(db, insertCmd, NULL, NULL, &pErrMsg))!=SQLITE_OK){
	
    /* If the error is 'no such table' It might be initial state */
    if(rc==SQLITE_ERROR && strstr(pErrMsg, "no such table:")!=NULL){

      /* retry from create */
      if(sqlite3_exec(db, createCmd, NULL, NULL, &pErrMsg)!=SQLITE_OK){
	resultFlag=FALSE;
	err_msg("ERR at %s#%d: sqlite3_exec: %s",__FILE__,__LINE__,pErrMsg);
      }
      if(sqlite3_exec(db, insertCmd, NULL, NULL, &pErrMsg)!=SQLITE_OK){
	resultFlag=FALSE;
	err_msg("ERR at %s#%d: sqlite3_exec: %s",__FILE__,__LINE__,pErrMsg);
      }
    }

    /* If the error is 'table session has no column named xxx' */
    /* It might be adding column in varsion up */
    else if(rc==SQLITE_ERROR && strstr(pErrMsg, "has no column named")!=NULL){
      err_msg("ERR at %s#%d: DB format is changed in version up, remove '%s' and retry",__FILE__,__LINE__,GetConfValue("SqliteDb"));
      resultFlag=FALSE;
    }

    /* Other errors */
    else{
      resultFlag=FALSE;
      err_msg("ERR at %s#%d: sqlite3_exec: %s",__FILE__,__LINE__,pErrMsg);
    }
  }

  /*Memory free for sqlite3 string */
  sqlite3_free(insertCmd);

  /* Sqlite close */
  sqlite3_close(db);

  return resultFlag;
}

/**************************************************************/
/* write session info to session control database at stop     */ 
/**************************************************************/
int putSessionEndToDb(char* cookie, char* watchMode){

  sqlite3 *db;
  char *pErrMsg;

  /* SQL UPDATE COMMAND, where %x is replaced in mprintf */
  char *updateFormat="UPDATE session SET closeTime=\
 datetime(%d,'unixepoch','localtime'), watchMode='%s' WHERE cookie='%s'";
  char *updateCmd;
  int resultFlag=TRUE;

  /* open sqlite */
  if(sqlite3_open(GetConfValue("SqliteDb"),&db)!=SQLITE_OK){
    err_msg("ERR at %s#%d: sqlite3_open",__FILE__,__LINE__);
    sqlite3_close(db);
    return FALSE;
  }
  
  /* prepare command */
  updateCmd=sqlite3_mprintf(updateFormat, time(NULL), watchMode, cookie);

  /* execute replace to sqlite */
  if(sqlite3_exec(db, updateCmd, NULL, NULL, &pErrMsg)!=SQLITE_OK){
    resultFlag=FALSE;
    err_msg("ERR at %s#%d: sqlite3_exec: %s",__FILE__,__LINE__,pErrMsg);
  }

  /*memory free for sqlite3 string */
  sqlite3_free(updateCmd);
  
  /* sqlite close */
  sqlite3_close(db);

  return resultFlag;
}

/*************************************************/
/* read userid and others from session database  */ 
/*************************************************/
int getSessionInfoFromDb(char* cookie, char* userid, 
			  char* clientAddr4, char *macAddr, 
			 int *duration, int *durationEntered, char *language){

  sqlite3 *db;
  sqlite3_stmt *stmt;
 
  /* SQL UPDATE COMMAND, where %x is replaced in snprintf */
  char *selectFormat="SELECT userid, clientAddr4, macAddr,\
 duration, durationEntered,language FROM session WHERE cookie='%s'";
  char *selectCmd;
  int resultFlag=TRUE;

  /* open sqlite */
  if(sqlite3_open(GetConfValue("SqliteDb"),&db)!=SQLITE_OK){
    err_msg("ERR at %s#%d: sqlite3_open",__FILE__,__LINE__);
    sqlite3_close(db);
    return FALSE;
  }

  /* prepare command string */
  selectCmd=sqlite3_mprintf(selectFormat, cookie);
  
  /* compile to internal statement */
  if(sqlite3_prepare(db, selectCmd, BUFFMAXLN, &stmt, NULL)!=SQLITE_OK){
    resultFlag=FALSE;
    err_msg("ERR at %s#%d: sqlite3_prepare:%s",__FILE__,__LINE__,
	    sqlite3_errmsg(db));

    /* finalize */
    sqlite3_free(selectCmd);
    sqlite3_finalize(stmt);
    sqlite3_close(db);
    return FALSE;
  }

  /* get first match item */
  if(sqlite3_step(stmt)==SQLITE_ROW){
    strncpy(userid, (char*)sqlite3_column_text(stmt, 0), USERMAXLN);
    strncpy(clientAddr4, (char*)sqlite3_column_text(stmt, 1), USERMAXLN);
    strncpy(macAddr, (char*)sqlite3_column_text(stmt, 2), USERMAXLN);
    *duration=(int)sqlite3_column_int(stmt, 3);
    *durationEntered=(int)sqlite3_column_int(stmt, 4);
    strncpy(language, (char*)sqlite3_column_text(stmt, 5), WORDMAXLN);
    resultFlag=TRUE;
  }else{
    resultFlag=FALSE;
  }
  
  /* finalize */
  sqlite3_free(selectCmd);
  sqlite3_finalize(stmt);
  sqlite3_close(db);
  
  return resultFlag;
}

/********************************************************/
/* get user property from property db (NOT implemented) */
/********************************************************/
int getUserProperty(char userid[USERMAXLN], char userProperty[BUFFMAXLN])
{
  /*****************************************************/
  /*  user database access routine                     */
  /*  userid[USERMAXLN]: input: user ID to search      */
  /*               Caution: "userid" if default server,*/
  /*                        "userid@serverid" if not.  */
  /*  userProperty[BUFFMAXLN]: output: user property   */
  /*                   the value goes to ipfwctrl.pl   */
  /*                   to determine permitting grade.  */     
  /*  return value: DENY or ACCEPT                     */
  /*     If DENY is returned, the user is denyed.      */
  /*     If ACCEPT, the value sent to firewall open.   */
  /*****************************************************/

  /* REPLACE THE FOLLOWING WITH YOUR DATABASE ACCESS ROUTINE */
  userProperty[0]='?';    
  userProperty[1]='\0';    /* The User has No Property */
  return ACCEPT;           /* The User is Accepted     */
}


/* debug write routine */
int PutSessionBeginToDb(char* cookie, char* userid, 
			char* clientAddr4, char* clientAddr6, 
			char* macAddr4, 
			char* ruleNumber4, char* ruleNumber6,
			int duration, int durationEntered, 
			int cookieAuth, char *language){
  int ret;

  if(debug>1) err_msg("DEBUG:=>putSessionBeginToDb(%s,%s,%s,%s,%s,%s,%s,%d,%d,%d,%s)",
		      cookie,userid,clientAddr4,clientAddr6,
		      macAddr4,ruleNumber4,ruleNumber6,
		      duration,durationEntered,cookieAuth,language);
  ret=putSessionBeginToDb(cookie,userid,clientAddr4,clientAddr6,
		      macAddr4,ruleNumber4,ruleNumber6,
			  duration,durationEntered,cookieAuth,language);
  if(debug>1) err_msg("DEBUG:(%d)<=putSessionBeginToDb()",ret);

  return ret;
}

int PutSessionEndToDb(char* cookie, char* watchMode){
  int ret;

  if(debug>1) err_msg("DEBUG:=>putSessionEndToDb(%s,%s)",cookie, watchMode);
  ret=putSessionEndToDb(cookie,watchMode);
  if(debug>1) err_msg("DEBUG:(%d)<=putSessionEndToDb()",ret);

  return ret;
}

int GetSessionInfoFromDb(char* cookie, char* userid, char* clientAddr4, 
			 char *macAddr, int *duration, int *durationEntered,
			 char *language){
  int ret;

  if(debug>1) err_msg("DEBUG:=>getInfoFromDb(%s)",cookie);
  ret=getSessionInfoFromDb(cookie,userid,clientAddr4, macAddr,
			   duration,durationEntered,language);
  if(debug>1) err_msg("DEBUG:(%d)<=getInfoFromDb(%s,%s,%s,%s,%d,%d,%s)",
		      ret,cookie,userid,clientAddr4, macAddr, 
		      *duration,*durationEntered,language);
  return ret;
}


int GetUserProperty(char *userid, char *userProperty)
{
  int ret;

  if(debug>1) err_msg("DEBUG:=>getUserProperty(%s,)",userid);
  ret=getUserProperty(userid,userProperty);
  if(debug>1) err_msg("DEBUG:(%d)<=getUserProperty(,%s)",ret, userProperty);

  return ret;
}

