#!/usr/bin/perl -U
#This is a script to remove superfluous rules left bihind at the abnormal termination of opengate process.

### this script is compatible with the format of opengate ver.1.3.1 or later.

#get opengate process information from 'ps x' output like following lines.
# and save it to $proc table.

# 1200 ?? | 0:00.00 opengatesrv.cgi: user1(useIPv6),[192.168.1.100(10000)],[2001:1:2:3:4:5:6:7(10000)](opengatesrv.cgi)
# 1200 ?? | 0:00.00 opengatesrv.cgi: user1,[192.168.1.100(10000)](opengatesrv.cgi)
# 1200 ?? | 0:00.00 opengatesrv.cgi: user1(useIPv6),,[2001:1:2:3:4:5:6:7(10000)](opengatesrv.cgi)

####
$ipfwmin=10000;
$ipfwmax=40000;
####

# get response from 'ps ax'
open(pspipe, "ps ax|");

while(<pspipe>){
    # get lines for opengatesrv process and divide it with ','
    if(/opengatesrv.cgi: (.*),(.*),(.*)/){
	$user=$1; $rule4=$2; $rule6=$3;
	
	# get the rule number for ipfw located between '(' and ')'
	if($rule4=~/\((\d*)\)\]/){
	    $rule4=$1;
	}else{
	    $rule4="";
	}

	# get the rule number for ip6fw located between '(' and ')'
	if($rule6=~/\((\d*)\)\]/){
	    $rule6=$1;
	}else{
	    $rule6="";
	}
	if($rule4!=""){
	    $proc4{$rule4}=1;
	}
	if($rule6!=""){
	    $proc6{$rule6}=1;
	}
    }
}
close(pspipe);


#get firewall rules from 'ipfw list' output,
# and delete the superfluous rules that are not included in $proc4 table.

open(ipfwpipe, "ipfw list|");
$delcount=0;
$rule=0;
while(<ipfwpipe>){
    if(/^(\d*) allow/){
	$rulesave=$rule;
	$rule=$1;
	if($rule>=$ipfwmin and $rule<=$ipfwmax and $rule!=$rulesave){
	    if(!defined($proc4{$rule})){
		system "ipfw del $rule";
		$delcount++;
	    }
	}
    }
}
close(ipfwpipe);

#get firewall rules from 'ip6fw list' output,
# and delete the superfluous rules that are not included in $proc6 table.
# ipfw deletes all rules having same rule number at once, 
# but ip6fw deletes first one rule for matched rule number.

open(ip6fwpipe, "ip6fw list|");
while(<ip6fwpipe>){
    if(/^(\d*) allow/){
	$rule=$1;
	if($rule>=$ipfwmin and $rule<=$ipfwmax){
	    if(!defined($proc6{$rule})){
		system "ip6fw del $rule";
		$delcount++;
	    }
	}
    }
}
close(ip6fwpipe);



