/**************************************************
opengate server test program 

Copyright (C) 2005 Opengate Project Team
Written by Yoshiaki Watanabe
Modified Katsuhiko Eguchi, 2005 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include	"opengatesrv.h"

/*********************/
/*  main routine     */
/*********************/
int  main(int argc, char **argv)
{
  char clientAddr[100];
  char userID[100]="user1";
  char extraID[100]="default";
  char dummy[100];
  struct clientAddr ClientAddr;
  struct clientAddr *pClientAddr;
  pClientAddr = &ClientAddr;

  printf("This is a program to test ipfw add/del rule \n\n");

  /* prepare config file */
  OpenConfFile();
 
  /* start log */
  errToSyslog(atoi(GetConfValue("Syslog/Enable")));
  openlog(argv[0], LOG_PID, atoi(GetConfValue("Syslog/Facility")));

  /* init config */
  InitConf();

  SetupConfExtra(userID, extraID);

  printf("Config file=[%s]\n",CONFIGFILE);
  printf("ExtraID=[%s]\n",extraID);

  /* get client address to add */
  printf("Enter IPv4 address to add rule in firewall=");
  scanf("%s",clientAddr);

  /* open firewall */
  OpenClientGate4(clientAddr,"user1",NULL,NULL);
  strncpy(ClientAddr.ipAddr,clientAddr,ADDRMAXLN);
  ClientAddr.ipType = IPV4;
  ClientAddr.timeIn = time(NULL);
  ClientAddr.next = NULL;

  /* wait input */
  printf("Check the addtion of firewall rules with ipfw command\n");
  printf("This program and ipfw command be executed by root user\n\n");
  printf("ENTER ANY charcter to remove the added rule\n\n");
  scanf("%s",dummy);
  strncpy(ClientAddr.ruleNumber,dummy,WORDMAXLN);

  /* close firewall */
  CloseClientGate4(pClientAddr,"user1",NULL);
  printf("Check the removal of firewall rule with ipfw command\n");

  /* get packet count */
  printf("Packet count for the rule is %d\n",GetPacketCount(pClientAddr));

  return 0;
}
