/**************************************************
opengate server
 module for communication with ndp

Copyright (C) 2004 Opengate Project Team
Written by  Katsuhiko Eguchi, 2004

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: eguchi@ai.is.saga-u.ac.jp
**************************************************/

#include "opengatesrv.h"

extern char ruleNumber6[WORDMAXLN];  /* ip6fw rule number in string form */

/**************************************/
/* scan client address form NDP entry */
/**************************************/
void scanNdpEntry(struct clientAddr *pClientAddr, char *userid, char *macAddr6, char *userProperty)
{
  FILE *fpipe;
  int ret;
  int set;
  char *startp;
  char buf[BUFFMAXLN];
  char tmpAddr[ADDRMAXLN]="";
  struct clientAddr *tmp1, *tmp2, *lastAddr;

  /* exec ndp */
  if( (fpipe=Popenl(1, "r", GetConfValue("NdpPath"), "-na", (char *)0)) == NULL){ 
    err_msg("ERR at %s#%d: exec ndp -na error",__FILE__,__LINE__);
    return;
  }
  
  /* get ndp response                                      */
  /* ndp response takes following format                   */
  /* "[IPv6Addr] [MacAddr] [InterfaceID] [Expire] [State]" */
  /* get IPv6 address from above string                    */

  /* clear active status for IPv6 address */
  lastAddr=tmp1=pClientAddr;
  while(tmp1!=NULL){
    if(tmp1->ipType==IPV6) tmp1->activeStatus=FALSE;
    lastAddr=tmp1;
    tmp1=tmp1->next;
  }
  
  /* skip first title line in ndp response */
  if(fgets(buf, BUFFMAXLN, fpipe)==NULL){
    err_msg("ERR at %s#%d: readin error",__FILE__,__LINE__);
    Pclose(fpipe);
    return;
  }
  
  /* get ndp response */
  /* ndp response is like [2001:10:20:30::1   0:10:20:30:40:50 ..] */
  while(fgets(buf, BUFFMAXLN, fpipe)!=NULL){

    /* find the separate point of IP(ip-ndp) and MAC */
    if((startp = strstr(buf," "))==NULL) break;

    /* if MAC is differed, skip the line. */
    if(strstr(startp,macAddr6)==NULL) continue;

    /* if ip-ndp has [fe80::]. skip the line */
    *startp = '\0';
    if(strstr(buf,"fe80::")!=NULL) continue;

    /* if the address is not registered, */
    /* regist it and open firewall for it */

    /* cut out ip-ndp */
    strncpy(tmpAddr,buf,ADDRMAXLN);

    /* get first ip-reg in address list */
    tmp1 = pClientAddr;

    /* init as ip-ndp is not set in list */
    set = FALSE;

    /* loop until list end */
    while(tmp1!=NULL){

      /* the list item is IPv4, skip it */
      if(tmp1->ipType==IPV4){
        tmp1=tmp1->next;
        continue;
      }
      /* if ip-ndp same as a list item, set it active */
      if(strstr(tmpAddr,tmp1->ipAddr)!=NULL){
        tmp1->activeStatus=TRUE;
        set = TRUE;
        break;
      }

      /* shift to next list item */
      tmp1=tmp1->next;
    }

    /* if ip-ndp is not registered, regist it and open firewall for it */
    if(set==FALSE){
      /* open firewall */
      if((ret=OpenClientGate6(tmpAddr, userid, macAddr6, userProperty))<0){
        err_msg("ERR at %s#%d: error return form openClientGate6",
		__FILE__,__LINE__);
        break;
      }
      err_msg("OPEN: user %s from %s at %s", userid, tmpAddr, macAddr6);

      /* add ip-ndp to the address list */
      lastAddr->next = CreateAddrListItem(tmpAddr,ruleNumber6,6);
      lastAddr=lastAddr->next;
    }
  }
  /* close pipe */
  Pclose(fpipe);


  /* check deleted address from ndp entry */
  tmp1 = pClientAddr;
  while(tmp1!=NULL){
    if(tmp1->activeStatus==FALSE){
      CloseClientGate6(tmp1,userid,macAddr6);
      tmp2=pClientAddr;
      while(tmp2->next!=tmp1){
        tmp2=tmp2->next;
      }
      tmp2->next=tmp1->next;
      tmp2=tmp1;
      tmp1=tmp1->next;
      free(tmp2);
      continue;
    }
    tmp1=tmp1->next;
  }

  return;
}

/**********************************************************************/
/* get MAC address for clientAddr (nnnn:nnnn::nnnn:nnnn) by ndp entry */
/**********************************************************************/
int getMacAddrFromNdp(char *clientAddr6, char* macAddr6)
{
  FILE *fpipe;
  char buf[BUFFMAXLN];
  char *startp;

  macAddr6[0]='?';
  macAddr6[1]='\0';

  /* exec proc */
  if((fpipe=Popenl(1, "r", GetConfValue("NdpPath"),"-na",(char *)0)) == NULL){ 
    err_msg("ERR at %s#%d: exec ndp -na error",__FILE__,__LINE__);
    return -1;
  }

  /* get ndp response */
  /* skip first title line */
  if(fgets(buf, BUFFMAXLN, fpipe)==NULL){
    err_msg("ERR at %s#%d: readin error",__FILE__,__LINE__);
    Pclose(fpipe);
    return -1;
  }
  
  /* arp response takes following format           */
  /* "[IPv6 Addr] [Mac] [InterfaseID] [Expire] [Status] [Flags] [Prbs]" */
  /* get MAC address from above string             */
  while(fgets(buf, BUFFMAXLN, fpipe)!=NULL){
    if(strstr(buf,clientAddr6)==NULL)continue;
    startp = strtok(buf," "); /* first token */
    startp = strtok(NULL," "); /* second token */
    strcpy(macAddr6,startp);
  }

  Pclose(fpipe);
  
  return 0;
}

/********************************************/
/* Delete NDP entry for closed IPv6 address */
/********************************************/
void deleteNdpEntry(char *clientAddr6)
{
  /* exec ndp */
  if(Systeml(1, GetConfValue("NdpPath"),"-nd",clientAddr6,(char *)0) != 0){
    err_msg("ERR at %s#%d: exec ndp -nd error",__FILE__,__LINE__);
  }
  return;
}

int GetMacAddrFromNdp(char *clientAddr6, char* macAddr6)
{
  int ret;

  if(debug>1) err_msg("DEBUG:=>getMacAddrFromNdp(%s,)",clientAddr6);
  ret=getMacAddrFromNdp(clientAddr6,macAddr6);
  if(debug>1) err_msg("DEBUG:(%d)<=getMacAddrFromNdp(,%s)",ret,macAddr6);

  return ret;
}

void DeleteNdpEntry(char *clientAddr6)
{
  if(debug>1) err_msg("DEBUG:=>deleteNdpEntry(%s)",clientAddr6);
  deleteNdpEntry(clientAddr6);
  if(debug>1) err_msg("DEBUG:<=deleteNdpEntry( )");
}

void ScanNdpEntry(struct clientAddr *pClientAddr, char *userid, char *macAddr6, char *userProperty)
{
  if(debug>1) err_msg("DEBUG:=>scanNdpEntry(%p,%s,%s,%s)",pClientAddr,userid,macAddr6, userProperty);
  scanNdpEntry(pClientAddr,userid,macAddr6,userProperty);
  if(debug>1) err_msg("DEBUG:<=scanNdpEntry( )");
}
