/**************************************************
opengate server
 module for Authentication by RADIUS

Copyright (C) 2002 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/
/*
  Thanks to programs and documentations refered.
   The experimental implementation by Fuyuta Sato.
   Manual files about RADIUS.
*/

#include <radlib.h>
#include "opengatesrv.h"

/*****************************************/
/* Authenticate by RADIUS */
/*****************************************/
int authRadius(char *userid, char *passwd)
{
  char* confFile;
  int           authResult;
  struct rad_handle *radh;
  char hostname[ADDRMAXLN];

  /* get radius config file path */
  confFile=GetConfValue("AuthServer/ConfFile");

  /* If not set, set default conf file path */
  if(isNull(confFile)){
    strncpy(confFile, RADIUSCONF, ADDRMAXLN);
  }

  if( !(radh=rad_auth_open()) ){
    err_msg("ERR at %s#%d: cannot start radius",__FILE__,__LINE__);
    return DENY;
  }

  if(gethostname(hostname,ADDRMAXLN) < 0){
    err_msg("ERR at %s#%d: cannot get hostname",__FILE__,__LINE__);
    return DENY;
  }
    
  if(rad_config(radh,confFile) < 0){
    err_msg("ERR at %s#%d: cannot open conffile",__FILE__,__LINE__);
    return DENY;
  }

  if(rad_create_request(radh, RAD_ACCESS_REQUEST) < 0){
    err_msg("ERR at %s#%d: cannot create radius request",__FILE__,__LINE__);
    return DENY;
  }

  rad_put_string(radh,RAD_USER_NAME,userid);
  rad_put_string(radh,RAD_USER_PASSWORD,passwd);
  rad_put_string(radh,RAD_NAS_IDENTIFIER,hostname);
  rad_put_int(radh,RAD_SERVICE_TYPE,RAD_LOGIN);

  switch(rad_send_request(radh)){
  case RAD_ACCESS_ACCEPT:
    authResult=ACCEPT;
    break;
  case RAD_ACCESS_REJECT:
  case RAD_ACCESS_CHALLENGE:
  case RAD_ACCOUNTING_RESPONSE:
  default:
    authResult=DENY;
    break;
  }

  return authResult;
}
  
int AuthRadius(char *userid, char *passwd)
{
  int ret;

  if(debug>1) err_msg("DEBUG:=>authRadius(%s,passwd)",userid);
  ret=authRadius(userid,passwd);
  if(debug>1) err_msg("DEBUG:(%d)<=authRadius( )",ret);

  return ret;
}
