/**************************************************
opengate server
 module for Authentication by POP3S

Copyright (C) 2002 Opengate Project Team
Written by Yoshiaki Watanabe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/
/*
  Thanks to programs and documentations refered.
   Sample client application cli.cpp found in the OpenSSL site 
    (developed by Sampo Kellomaki and simplified by Wade Scholine) 
   Apache module mod_auth_pam.c by Ingo Luetkebohle
*/

#include "opengatesrv.h"

/*************************/
/* Authenticate by POP3S */
/*************************/
int authPop3s(char *userid, char *passwd)
{
  char* serverAddr;
  char* port;
  int		sockfd, n;
  char		recvline[BUFFMAXLN];
  int           authResult;
  SSL_CTX    *ctx;
  SSL        *ssl;
  SSL_METHOD *meth;

  /* get auth server address */
  serverAddr=GetConfValue("AuthServer/Address");

  if(isNull(serverAddr)){
    err_msg("ERR at %s#%d: Missing address for POP3s server in config",
	    __FILE__,__LINE__);
    return DENY;
  }

  /* get auth server port */
  port=GetConfValue("AuthServer/Port");

  /* POP3S server connect */
  if(isNull(port)){
    sockfd = Tcp_connect(serverAddr, "pop3s");
  }else{
    sockfd = Tcp_connect(serverAddr, port);
  }
  if(sockfd<0){
    err_msg("ERR at %s#%d: Pop3s server is not normal 0",__FILE__,__LINE__);
    return DENY;
  }

  /* prepare SSL */
  SSLeay_add_ssl_algorithms();
  meth = SSLv2_client_method();
  SSL_load_error_strings();
  ctx = SSL_CTX_new (meth);
  if( ctx == NULL ){
    err_msg("ERR at %s#%d: SSL_CTX_new returns NULL",__FILE__,__LINE__);
    return DENY;
  }
  
  /* ----------------------------------------------- */
  /* start SSL negotiation. */
  
  ssl = SSL_new (ctx);
  if( ssl == NULL ){
    err_msg("ERR at %s#%d: SSL_new returns NULL",__FILE__,__LINE__);
    return DENY;
  }

  SSL_set_fd (ssl, sockfd);
  if( SSL_connect (ssl) == -1 ){
    err_msg("ERR at %s#%d: SSL_connect returns error",__FILE__,__LINE__);
    return DENY;
  }

  /* --------------------------------------------------- */
  /* DATA EXCHANGE - Send a message and receive a reply. */
  /*  pop3 message exchange */

  /* get [+OK POP3 <host> <ver> server ready]*/
  if((n = readlnSSL(ssl, recvline, BUFFMAXLN)) < 0) {
    err_msg("ERR at %s#%d: Pop3s server is not normal 1",__FILE__,__LINE__);
    authResult=DENY;
    goto EXITPOINT;
  }

  if(strstr(recvline,"+OK")!=recvline){
    err_msg("ERR at %s#%d: Pop3s server is not normal 2",__FILE__,__LINE__);
    authResult=DENY;
    goto EXITPOINT;
  }

  /* put [user <userid>] */
  WritefmtSSL(ssl, "user %s\r\n", userid);

  /* get [+OK User name accepted, password please] */
  if((n = readlnSSL(ssl, recvline, BUFFMAXLN)) < 0) {
    err_msg("ERR at %s#%d: Pop3s server is not normal 3",__FILE__,__LINE__);
    authResult=DENY;
    goto EXITPOINT;
  }

  if(strstr(recvline,"+OK")!=recvline){
    err_msg("ERR at %s#%d: Pop3s server is not normal 4",__FILE__,__LINE__);
    authResult=DENY;
    goto EXITPOINT;
  }

  /* put [pass <password>] */
  WritefmtSSL(ssl, "pass %s\r\n", passwd);

  /* get [+OK Mailbox open, <count> messages] */
  if((n = readlnSSL(ssl, recvline, BUFFMAXLN)) < 0) {
    err_msg("ERR at %s#%d: Pop3s server is not normal 5",__FILE__,__LINE__);
    authResult=DENY;
    goto EXITPOINT;
  }

  if(strstr(recvline,"+OK")==recvline){
    authResult=ACCEPT;
  }else{
    authResult=DENY;
  }
  
  /* put [quit] */
  WritefmtSSL(ssl,"quit\r\n");

EXITPOINT:
  SSL_shutdown (ssl);  /* send SSL/TLS close_notify */

  /* Clean up. */
  Close(sockfd);
  SSL_free (ssl);
  SSL_CTX_free (ctx);

  return authResult;
}

int AuthPop3s(char *userid, char *passwd)
{
  int ret;

  if(debug>1) err_msg("DEBUG:=>authPop3s(%s,passwd)",userid);
  ret=authPop3s(userid,passwd);
  if(debug>1) err_msg("DEBUG:(%d)<=authPop3s( )",ret);

  return ret;
}
