/**************************************************/
/* opengate client                                */
/**************************************************
opengate client
 java applet downloaded to client machine 

Copyright (C) 1999-2002 Opengate Project Team

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

Email: watanaby@is.saga-u.ac.jp

Written by Yoshiaki WATANABE, Saga University
Modified by Shin-ichi TADAKI, Saga University
**************************************************/
import java.awt.*;
import java.applet.*;
import java.net.*;
import java.io.*;
 
/** Wrapper to make Applet **/
public class Opengate extends Applet{

  String hostname;
  int port;
  String userid;
  String sessionId;
  String language;
  int intlang=0;/* if language is japanese, set 1*/
  OpengateClient client;
  Label headlabel;
  Label userlabel;
  Label msglabel;

   /* Applet initialize */
  public void init(){

     /* Get Applet Parameters */
    port=Integer.parseInt(getParameter("port"));
    userid=getParameter("user");
    sessionId=getParameter("sessionid");
    hostname =getCodeBase().getHost();
    language = getParameter("lang");
    if(language.equals("ja")) intlang=1;
    if(language.equals("en")) intlang=2;

     /* Panel Layout */
    setLayout(new FlowLayout(FlowLayout.CENTER));
    setBackground(Color.yellow);
 
      /* Make Label */
    if(intlang ==1){
      add(headlabel=new Label("lbg[Np"));
      add(userlabel=new Label("[U="+userid));
      add(msglabel=new Label("Java AppletN܂ @@@    @@@@@ "));
    } else {
      add(headlabel=new Label("Authenticated for network use"));
      add(userlabel=new Label("User name="+userid));
      add(msglabel=new Label("Java Applet is running                       "));
    }

     /* Connect to Server */
    client=new OpengateClient(hostname, port, userid, sessionId, intlang, this);
    client.start();
  }
  public void msgout(String msg){
    /*    byte[] code = msg.getBytes("EUCJIS");
    String msgj=new String(code,"EUCJIS");
    */
	/* padding space char to required length */
	for(int i=msg.length();i<40;i++) msg+=" ";
    msglabel.setText(msg);
    repaint();
  }
  public void stop(){
    try{
      client.join();
    }catch(InterruptedException e){
      msgout("Error at Client Join            ");
    }
  }
}

/**  Class for Client to communicate with host **/
class OpengateClient extends Thread{
  int port;                  /* opengate port */
  String hostname;           /* java download host name */
  Socket socket;             /* Socket for server */
  String userid;
  String sessionId;
  PrintStream outStream;     /* output stream to server */
  BufferedReader inStream;   /* input stream from server */
  String currentReply;       /* reserve last reply from server */
  boolean onLine;            /* Client is connected to server or not */
  Opengate main;             /* main class */
  int intlang;

  /* Instance Creater */
  public OpengateClient(String hostname, int port, 
			String userid, String sessionId, int intlang, Opengate main){
    this.hostname=hostname;
    this.port=port;
    this.userid=userid;
    this.sessionId=sessionId;
    this.main=main;
    this.intlang=intlang;
    onLine=false;
  }

  /* connect to server */
  boolean connect(){
    try{
      if(intlang==1){
	main.msgout("zXg"+hostname+":"+Integer.toString(port)+"ɐڑł");
      } else {
	main.msgout("Connecting to host "+hostname+":"+Integer.toString(port));
      }
      socket=new Socket(hostname, port);
      outStream=new PrintStream(socket.getOutputStream());
      inStream=new BufferedReader(
                   new InputStreamReader(
                       socket.getInputStream()));
    }catch(UnknownHostException e){
      if(intlang==1)
	main.msgout("SocketConnectUnknownHostO܂");
      else 
	main.msgout("UnknownHost exception in SocketConnect");
      return false;
    }catch(IOException e){
      if(intlang==1)
	main.msgout("SocketConnectI/OO܂");
      else
	main.msgout("I/O exception in SocketConnect");
      return false;
    }
    onLine=true;
    return true;
  }

  /* disconnect from server */
  void disconnect(){
    if(onLine){
      putLine("quit");
    }
    if(socket!=null){
      try{
        socket.close();
      }catch(IOException e){
	if(intlang==1)
	  main.msgout("SocketCloseI/OO܂");
	else
	  main.msgout("I/O exception in SocketClose");
      }
    }
  }

  /* put out one line to server */
  void putLine(String string){
    outStream.print(string+"\r\n");
  }

  /* get one line from server */
  String getLine(){
    try{
      currentReply=inStream.readLine();
    }catch(IOException e){
      if(intlang==1)
	main.msgout("SocketReadI/OO܂");
      else
	main.msgout("I/O exception in SocketRead");
      return "";
    }
    return currentReply;
  }

  /* called back from client.start */
  public void run(){
    int count=0;
    java.text.SimpleDateFormat formatter 
              =new java.text.SimpleDateFormat("H:mm") ;
    if(connect()==false){
      disconnect();
      return;
    }
    putLine(userid+"-"+sessionId);
    if(getLine().indexOf("accept")==-1){
      if(intlang==1)
	main.msgout("T[oAcceptė܂");
      else 
	main.msgout("Not receive Accept from the server");
      disconnect();
      return;
    }
    if(intlang==1)
      main.msgout("ɊJn܂");
    else
      main.msgout("Start Normally");

    while(getLine().indexOf("hello")!=-1){
      putLine("hello");
      if(intlang==1){
	main.msgout("ڑmF="+formatter.format(new java.util.Date()));
      } else {
	main.msgout("Confirm connection="+formatter.format(new java.util.Date()));  
      }
    }
    if(intlang==1)
      main.msgout("lbg[N͕܂");
    else 
      main.msgout("Connection closed");
    return;
  }                                          
}

