/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;

class OpengateClient
extends Thread {
    int port;
    String hostname;
    Socket socket;
    String userid;
    String sessionId;
    PrintStream outStream;
    BufferedReader inStream;
    String currentReply;
    boolean onLine;
    Opengate main;
    int intlang;

    public OpengateClient(String string, int n, String string2, String string3, int n2, Opengate opengate) {
        this.hostname = string;
        this.port = n;
        this.userid = string2;
        this.sessionId = string3;
        this.main = opengate;
        this.intlang = n2;
        this.onLine = false;
    }

    boolean connect() {
        try {
            if (this.intlang == 1) {
                this.main.msgout("\u30db\u30b9\u30c8" + this.hostname + ":" + Integer.toString(this.port) + "\u306b\u63a5\u7d9a\u4e2d\u3067\u3059");
            } else {
                this.main.msgout("Connecting to host " + this.hostname + ":" + Integer.toString(this.port));
            }
            this.socket = new Socket(this.hostname, this.port);
            this.outStream = new PrintStream(this.socket.getOutputStream());
            this.inStream = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (UnknownHostException unknownHostException) {
            if (this.intlang == 1) {
                this.main.msgout("SocketConnect\u4e2d\u306bUnknownHost\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            } else {
                this.main.msgout("UnknownHost exception in SocketConnect");
            }
            return false;
        }
        catch (IOException iOException) {
            if (this.intlang == 1) {
                this.main.msgout("SocketConnect\u4e2d\u306bI/O\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            } else {
                this.main.msgout("I/O exception in SocketConnect");
            }
            return false;
        }
        this.onLine = true;
        return true;
    }

    void disconnect() {
        if (this.onLine) {
            this.putLine("quit");
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                if (this.intlang == 1) {
                    this.main.msgout("SocketClose\u4e2d\u306bI/O\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
                }
                this.main.msgout("I/O exception in SocketClose");
            }
        }
    }

    void putLine(String string) {
        this.outStream.print(string + "\r\n");
    }

    String getLine() {
        try {
            this.currentReply = this.inStream.readLine();
        }
        catch (IOException iOException) {
            if (this.intlang == 1) {
                this.main.msgout("SocketRead\u4e2d\u306bI/O\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            } else {
                this.main.msgout("I/O exception in SocketRead");
            }
            return "";
        }
        return this.currentReply;
    }

    public void run() {
        boolean bl = false;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H:mm");
        if (!this.connect()) {
            this.disconnect();
            return;
        }
        this.putLine(this.userid + "-" + this.sessionId);
        if (this.getLine().indexOf("accept") == -1) {
            if (this.intlang == 1) {
                this.main.msgout("\u30b5\u30fc\u30d0\u304b\u3089Accept\u304c\u9001\u3089\u308c\u3066\u6765\u307e\u305b\u3093");
            } else {
                this.main.msgout("Not receive Accept from the server");
            }
            this.disconnect();
            return;
        }
        if (this.intlang == 1) {
            this.main.msgout("\u6b63\u5e38\u306b\u958b\u59cb\u3057\u307e\u3057\u305f");
        } else {
            this.main.msgout("Start Normally");
        }
        while (this.getLine().indexOf("hello") != -1) {
            this.putLine("hello");
            if (this.intlang == 1) {
                this.main.msgout("\u63a5\u7d9a\u78ba\u8a8d=" + simpleDateFormat.format(new Date()));
                continue;
            }
            this.main.msgout("Confirm connection=" + simpleDateFormat.format(new Date()));
        }
        if (this.intlang == 1) {
            this.main.msgout("\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u306f\u9589\u9396\u3055\u308c\u307e\u3057\u305f");
        } else {
            this.main.msgout("Connection closed");
        }
    }
}

